/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation;

import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public class AggreResultData {
    private long timestamp;
    private TSDataType dataType;
    private boolean booleanRet;
    private int intRet;
    private long longRet;
    private float floatRet;
    private double doubleRet;
    private Binary binaryRet;
    private boolean isSetValue;
    private boolean isSetTime;

    public AggreResultData(TSDataType dataType) {
        this.dataType = dataType;
        this.isSetTime = false;
        this.isSetValue = false;
    }

    public void reset() {
        this.isSetValue = false;
        this.isSetTime = false;
    }

    public void putTimeAndValue(long timestamp, Object v) {
        this.setTimestamp(timestamp);
        this.setAnObject((Comparable)v);
    }

    public Object getValue() {
        switch (this.dataType) {
            case BOOLEAN: {
                return this.booleanRet;
            }
            case DOUBLE: {
                return this.doubleRet;
            }
            case TEXT: {
                return this.binaryRet;
            }
            case FLOAT: {
                return Float.valueOf(this.floatRet);
            }
            case INT32: {
                return this.intRet;
            }
            case INT64: {
                return this.longRet;
            }
        }
        throw new UnSupportedDataTypeException(String.valueOf(this.dataType));
    }

    public void setAnObject(Comparable<?> v) {
        this.isSetValue = true;
        switch (this.dataType) {
            case BOOLEAN: {
                this.booleanRet = (Boolean)v;
                break;
            }
            case DOUBLE: {
                this.doubleRet = (Double)v;
                break;
            }
            case TEXT: {
                this.binaryRet = (Binary)v;
                break;
            }
            case FLOAT: {
                this.floatRet = ((Float)v).floatValue();
                break;
            }
            case INT32: {
                this.intRet = (Integer)v;
                break;
            }
            case INT64: {
                this.longRet = (Long)v;
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf(this.dataType));
            }
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.isSetTime = true;
        this.timestamp = timestamp;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public boolean isBooleanRet() {
        return this.booleanRet;
    }

    public void setBooleanRet(boolean booleanRet) {
        this.isSetValue = true;
        this.booleanRet = booleanRet;
    }

    public int getIntRet() {
        return this.intRet;
    }

    public void setIntRet(int intRet) {
        this.isSetValue = true;
        this.intRet = intRet;
    }

    public long getLongRet() {
        return this.longRet;
    }

    public void setLongRet(long longRet) {
        this.isSetValue = true;
        this.longRet = longRet;
    }

    public float getFloatRet() {
        return this.floatRet;
    }

    public void setFloatRet(float floatRet) {
        this.isSetValue = true;
        this.floatRet = floatRet;
    }

    public double getDoubleRet() {
        return this.doubleRet;
    }

    public void setDoubleRet(double doubleRet) {
        this.isSetValue = true;
        this.doubleRet = doubleRet;
    }

    public Binary getBinaryRet() {
        return this.binaryRet;
    }

    public void setBinaryRet(Binary binaryRet) {
        this.isSetValue = true;
        this.binaryRet = binaryRet;
    }

    public boolean isSetValue() {
        return this.isSetValue;
    }

    public boolean isSetTime() {
        return this.isSetTime;
    }

    public AggreResultData deepCopy() {
        AggreResultData aggreResultData = new AggreResultData(this.dataType);
        if (this.isSetValue) {
            aggreResultData.setAnObject((Comparable)this.getValue());
        }
        if (this.isSetTime) {
            aggreResultData.setTimestamp(this.getTimestamp());
        }
        return aggreResultData;
    }
}

