/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.sys.MetadataOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;

public class MetadataPlan
extends PhysicalPlan {
    private final MetadataOperator.NamespaceType namespaceType;
    private Path path;
    private TSDataType dataType;
    private CompressionType compressor;
    private TSEncoding encoding;
    private Map<String, String> props;
    private List<Path> deletePathList;

    public MetadataPlan(MetadataOperator.NamespaceType namespaceType, Path path, TSDataType dataType, CompressionType compressor, TSEncoding encoding, Map<String, String> props, List<Path> deletePathList) {
        super(false, Operator.OperatorType.METADATA);
        this.namespaceType = namespaceType;
        this.path = path;
        this.dataType = dataType;
        this.compressor = compressor;
        this.encoding = encoding;
        this.props = props;
        this.deletePathList = deletePathList;
        switch (namespaceType) {
            case SET_FILE_LEVEL: {
                this.setOperatorType(Operator.OperatorType.SET_STORAGE_GROUP);
                break;
            }
            case ADD_PATH: {
                this.setOperatorType(Operator.OperatorType.CREATE_TIMESERIES);
                break;
            }
            case DELETE_PATH: {
                this.setOperatorType(Operator.OperatorType.DELETE_TIMESERIES);
                break;
            }
        }
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    public CompressionType getCompressor() {
        return this.compressor;
    }

    public void setCompressor(CompressionType compressor) {
        this.compressor = compressor;
    }

    public TSEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(TSEncoding encoding) {
        this.encoding = encoding;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public MetadataOperator.NamespaceType getNamespaceType() {
        return this.namespaceType;
    }

    public String toString() {
        String ret = String.format("seriesPath: %s%nresultDataType: %s%nencoding: %s%nnamespace type: %s%nargs: ", new Object[]{this.path, this.dataType, this.encoding, this.namespaceType});
        StringBuilder stringBuilder = new StringBuilder(ret.length() + 50);
        stringBuilder.append(ret);
        for (Map.Entry<String, String> prop : this.props.entrySet()) {
            stringBuilder.append((Object)prop.getKey()).append("=").append((Object)prop.getValue()).append(",");
        }
        return stringBuilder.toString();
    }

    public void addDeletePath(Path path) {
        this.deletePathList.add(path);
    }

    public List<Path> getDeletePathList() {
        return this.deletePathList;
    }

    @Override
    public List<Path> getPaths() {
        if (this.deletePathList != null) {
            return this.deletePathList;
        }
        ArrayList<Path> ret = new ArrayList<Path>();
        if (this.path != null) {
            ret.add(this.path);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetadataPlan)) {
            return false;
        }
        MetadataPlan that = (MetadataPlan)o;
        return this.getNamespaceType() == that.getNamespaceType() && Objects.equals(this.getPath(), that.getPath()) && this.getDataType() == that.getDataType() && this.getCompressor() == that.getCompressor() && this.getEncoding() == that.getEncoding() && Objects.equals(this.getProps(), that.getProps()) && Objects.equals(this.getDeletePathList(), that.getDeletePathList());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getNamespaceType(), this.getPath(), this.getDataType(), this.getCompressor(), this.getEncoding(), this.getProps(), this.getDeletePathList()});
    }
}

