/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.constant;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.qp.LogicalOperatorException;

public class DatetimeUtils {
    public static final DateTimeFormatter ISO_LOCAL_DATE_WIDTH_1_2 = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).toFormatter();
    public static final DateTimeFormatter ISO_LOCAL_DATE_WITH_SLASH = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('/').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('/').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).toFormatter();
    public static final DateTimeFormatter ISO_LOCAL_DATE_WITH_DOT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('.').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('.').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).toFormatter();
    public static final DateTimeFormatter ISO_LOCAL_TIME_WITH_MS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3).optionalEnd().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_MS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WIDTH_1_2).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SPACE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
    public static final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendOptional(ISO_OFFSET_DATE_TIME_WITH_MS).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SPACE).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE).toFormatter();

    private DatetimeUtils() {
    }

    public static long convertDatetimeStrToMillisecond(String str, ZoneId zoneId) throws LogicalOperatorException {
        return DatetimeUtils.convertDatetimeStrToMillisecond(str, DatetimeUtils.toZoneOffset(zoneId), 0);
    }

    public static long convertDatetimeStrToMillisecond(String str, ZoneOffset offset, int depth) throws LogicalOperatorException {
        if (depth >= 2) {
            throw new DateTimeException(String.format("Failed to convert %s to millisecond, zone offset is %s, please input like 2011-12-03T10:15:30 or 2011-12-03T10:15:30+01:00", str, offset));
        }
        if (str.contains("Z")) {
            return DatetimeUtils.convertDatetimeStrToMillisecond(str.substring(0, str.indexOf(90)) + "+00:00", offset, depth);
        }
        if (str.length() - str.lastIndexOf(43) != 6 && str.length() - str.lastIndexOf(45) != 6) {
            return DatetimeUtils.convertDatetimeStrToMillisecond(str + offset, offset, depth + 1);
        }
        if (str.contains("[") || str.contains("]")) {
            throw new DateTimeException(String.format("%s with [time-region] at end is not supported now, please input like 2011-12-03T10:15:30 or 2011-12-03T10:15:30+01:00", str));
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(str, formatter);
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public static ZoneOffset toZoneOffset(ZoneId zoneId) {
        return zoneId.getRules().getOffset(Instant.now());
    }

    public static ZonedDateTime convertMillsecondToZonedDateTime(long millisecond) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millisecond), IoTDBDescriptor.getInstance().getConfig().getZoneID());
    }
}

