/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.iotdb.db.exception.PathErrorException;
import org.apache.iotdb.db.metadata.MTree;
import org.apache.iotdb.db.metadata.PNode;

public class PTree
implements Serializable {
    private static final long serialVersionUID = 2642766399323283900L;
    private static final String PTREE_NOT_EXIST = "PTree seriesPath not exist. ";
    private PNode root;
    private MTree mTree;
    private String name;
    private String space = "    ";

    public PTree(String name, MTree mTree) {
        this.setRoot(new PNode(name, null, false));
        this.setName(name);
        this.setmTree(mTree);
    }

    public PTree(String name, PNode root, MTree mTree) {
        this.setName(name);
        this.setRoot(root);
        this.setmTree(mTree);
    }

    public int addPath(String path) throws PathErrorException {
        int i;
        int addCount = 0;
        if (this.getRoot() == null) {
            throw new PathErrorException("Root Node is null, Please initialize root first");
        }
        String[] nodes = path.trim().split("\\.");
        if (nodes.length <= 1 || !nodes[0].equals(this.getRoot().getName())) {
            throw new PathErrorException("Input seriesPath not exist. Path: " + path);
        }
        PNode cur = this.getRoot();
        for (i = 1; i < nodes.length - 1; ++i) {
            if (!cur.hasChild(nodes[i])) {
                cur.addChild(nodes[i], new PNode(nodes[i], cur, false));
                ++addCount;
            }
            cur = cur.getChild(nodes[i]);
        }
        if (cur.hasChild(nodes[i])) {
            throw new PathErrorException("Path already exists. Path: " + path);
        }
        PNode node = new PNode(nodes[i], cur, true);
        cur.addChild(node.getName(), node);
        return ++addCount;
    }

    public void deletePath(String path) throws PathErrorException {
        String[] nodes = path.split("\\.");
        if (nodes.length == 0 || !nodes[0].equals(this.getRoot().getName())) {
            throw new PathErrorException("Path not correct. Path:" + path);
        }
        PNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                throw new PathErrorException("Path not correct. Node[" + cur.getName() + "] doesn't have child named:" + nodes[i]);
            }
            cur = cur.getChild(nodes[i]);
        }
        cur.getParent().deleteChild(cur.getName());
    }

    public void linkMNode(String pTreePath, String mTreePath) throws PathErrorException {
        ArrayList<String> paths = this.mTree.getAllPathInList(mTreePath);
        String[] nodes = pTreePath.trim().split("\\.");
        PNode leaf = this.getLeaf(this.getRoot(), nodes, 0);
        for (String p : paths) {
            leaf.linkMPath(p);
        }
    }

    public void unlinkMNode(String pTreePath, String mTreePath) throws PathErrorException {
        ArrayList<String> paths = this.mTree.getAllPathInList(mTreePath);
        String[] nodes = pTreePath.trim().split("\\.");
        PNode leaf = this.getLeaf(this.getRoot(), nodes, 0);
        for (String p : paths) {
            leaf.unlinkMPath(p);
        }
    }

    private PNode getLeaf(PNode node, String[] nodes, int idx) throws PathErrorException {
        if (idx >= nodes.length) {
            throw new PathErrorException(PTREE_NOT_EXIST);
        }
        if (node.isLeaf()) {
            if (idx != nodes.length - 1 || !nodes[idx].equals(node.getName())) {
                throw new PathErrorException(PTREE_NOT_EXIST);
            }
            return node;
        }
        if (idx >= nodes.length - 1 || !node.hasChild(nodes[idx + 1])) {
            throw new PathErrorException(PTREE_NOT_EXIST);
        }
        return this.getLeaf(node.getChild(nodes[idx + 1]), nodes, idx + 1);
    }

    public HashMap<String, ArrayList<String>> getAllLinkedPath(String path) throws PathErrorException {
        String[] nodes = path.trim().split("\\.");
        PNode leaf = this.getLeaf(this.getRoot(), nodes, 0);
        HashMap<String, ArrayList<String>> res = new HashMap<String, ArrayList<String>>();
        for (String MPath : leaf.getLinkedMTreePathMap().keySet()) {
            HashMap<String, ArrayList<String>> tr = this.getmTree().getAllPath(MPath);
            this.mergePathRes(res, tr);
        }
        return res;
    }

    private void mergePathRes(HashMap<String, ArrayList<String>> res, HashMap<String, ArrayList<String>> tr) {
        for (String key : tr.keySet()) {
            if (!res.containsKey(key)) {
                res.put(key, new ArrayList());
            }
            for (String p : tr.get(key)) {
                if (res.get(key).contains(p)) continue;
                res.get(key).add(p);
            }
        }
    }

    public String toString() {
        return this.pNodeToString(this.getRoot(), 0);
    }

    private String pNodeToString(PNode node, int tab) {
        String s = "";
        for (int i = 0; i < tab; ++i) {
            s = s + this.space;
        }
        s = s + node.getName();
        if (!node.isLeaf() && node.getChildren().size() > 0) {
            s = s + ":{\n";
            boolean first = false;
            for (PNode child : node.getChildren().values()) {
                if (!first) {
                    first = true;
                } else {
                    s = s + ",\n";
                }
                s = s + this.pNodeToString(child, tab + 1);
            }
            s = s + "\n";
            for (int i = 0; i < tab; ++i) {
                s = s + this.space;
            }
            s = s + "}";
        } else if (node.isLeaf()) {
            s = s + ":{\n";
            String[] linkedPaths = new String[node.getLinkedMTreePathMap().values().size()];
            linkedPaths = node.getLinkedMTreePathMap().values().toArray(linkedPaths);
            for (int i = 0; i < linkedPaths.length; ++i) {
                s = i != linkedPaths.length - 1 ? s + this.getTabs(tab + 1) + linkedPaths[i] + ",\n" : s + this.getTabs(tab + 1) + linkedPaths[i] + "\n";
            }
            s = s + this.getTabs(tab) + "}";
        }
        return s;
    }

    private String getTabs(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(this.space);
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MTree getmTree() {
        return this.mTree;
    }

    public void setmTree(MTree mTree) {
        this.mTree = mTree;
    }

    public PNode getRoot() {
        return this.root;
    }

    public void setRoot(PNode root) {
        this.root = root;
    }
}

