/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.PathErrorException;
import org.apache.iotdb.db.metadata.MNode;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MTree
implements Serializable {
    private static final long serialVersionUID = -4200394435237291964L;
    private static final String DOUB_SEPARATOR = "\\.";
    private static final String NO_CHILD_ERROR = "Timeseries is not correct. Node[%s] doesn't have child named:%s";
    private static final String NOT_LEAF_NODE = "Timeseries %s is not the leaf node";
    private static final String SERIES_NOT_CORRECT = "Timeseries %s is not correct";
    private static final String NOT_SERIES_PATH = "The prefix of the seriesPath %s is not one storage group seriesPath";
    private MNode root;

    MTree(String rootName) {
        this.root = new MNode(rootName, null, false);
    }

    public MTree(MNode root) {
        this.root = root;
    }

    void addTimeseriesPath(String timeseriesPath, String dataType, String encoding) throws PathErrorException {
        TSDataType tsDataType = TSDataType.valueOf((String)dataType);
        TSEncoding tsEncoding = TSEncoding.valueOf((String)encoding);
        CompressionType compressionType = CompressionType.valueOf((String)TSFileConfig.compressor);
        this.addTimeseriesPath(timeseriesPath, tsDataType, tsEncoding, compressionType, Collections.emptyMap());
    }

    void addTimeseriesPath(String timeseriesPath, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws PathErrorException {
        String[] nodeNames = timeseriesPath.trim().split(DOUB_SEPARATOR);
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new PathErrorException(String.format("Timeseries %s is not right.", timeseriesPath));
        }
        MNode cur = this.findLeafParent(nodeNames);
        String levelPath = cur.getDataFileName();
        MNode leaf = new MNode(nodeNames[nodeNames.length - 1], cur, dataType, encoding, compressor);
        if (props != null && !props.isEmpty()) {
            leaf.getSchema().setProps(props);
        }
        leaf.setDataFileName(levelPath);
        if (cur.isLeaf()) {
            throw new PathErrorException(String.format("The Node [%s] is left node, the timeseries %s can't be created", cur.getName(), timeseriesPath));
        }
        cur.addChild(nodeNames[nodeNames.length - 1], leaf);
    }

    private MNode findLeafParent(String[] nodeNames) throws PathErrorException {
        MNode cur = this.root;
        String levelPath = null;
        for (int i = 1; i < nodeNames.length - 1; ++i) {
            String nodeName = nodeNames[i];
            if (cur.isStorageLevel()) {
                levelPath = cur.getDataFileName();
            }
            if (!cur.hasChild(nodeName)) {
                if (cur.isLeaf()) {
                    throw new PathErrorException(String.format("The Node [%s] is left node, the timeseries %s can't be created", cur.getName(), String.join((CharSequence)",", nodeNames)));
                }
                cur.addChild(nodeName, new MNode(nodeName, cur, false));
            }
            cur.setDataFileName(levelPath);
            cur = cur.getChild(nodeName);
            if (levelPath != null) continue;
            levelPath = cur.getDataFileName();
        }
        cur.setDataFileName(levelPath);
        return cur;
    }

    boolean isPathExist(String path) {
        String[] nodeNames = path.trim().split(DOUB_SEPARATOR);
        MNode cur = this.root;
        int i = 0;
        while (i < nodeNames.length - 1) {
            String nodeName = nodeNames[i];
            if (cur.getName().equals(nodeName)) {
                if (cur.hasChild(nodeName = nodeNames[++i])) {
                    cur = cur.getChild(nodeName);
                    continue;
                }
                return false;
            }
            return false;
        }
        return cur.getName().equals(nodeNames[i]);
    }

    boolean isPathExist(MNode node, String path) {
        String[] nodeNames = path.trim().split(DOUB_SEPARATOR);
        if (nodeNames.length < 1) {
            return true;
        }
        if (!node.hasChild(nodeNames[0])) {
            return false;
        }
        MNode cur = node.getChild(nodeNames[0]);
        int i = 0;
        while (i < nodeNames.length - 1) {
            String nodeName = nodeNames[i];
            if (cur.getName().equals(nodeName)) {
                if (cur.hasChild(nodeName = nodeNames[++i])) {
                    cur = cur.getChild(nodeName);
                    continue;
                }
                return false;
            }
            return false;
        }
        return cur.getName().equals(nodeNames[i]);
    }

    public void setStorageGroup(String path) throws PathErrorException {
        MNode temp;
        int i;
        String[] nodeNames = path.split(DOUB_SEPARATOR);
        MNode cur = this.root;
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new PathErrorException(String.format("The storage group can't be set to the %s node", path));
        }
        for (i = 1; i < nodeNames.length - 1; ++i) {
            temp = cur.getChild(nodeNames[i]);
            if (temp == null) {
                cur.addChild(nodeNames[i], new MNode(nodeNames[i], cur, false));
            } else if (temp.isStorageLevel()) {
                throw new PathErrorException(String.format("The prefix of %s has been set to the storage group.", path));
            }
            cur = cur.getChild(nodeNames[i]);
        }
        temp = cur.getChild(nodeNames[i]);
        if (temp != null) {
            throw new PathErrorException(String.format("The seriesPath of %s already exist, it can't be set to the storage group", path));
        }
        cur.addChild(nodeNames[i], new MNode(nodeNames[i], cur, false));
        cur = cur.getChild(nodeNames[i]);
        cur.setStorageLevel(true);
        this.setDataFileName(path, cur);
    }

    boolean checkStorageGroup(String path) {
        MNode temp;
        int i;
        String[] nodeNames = path.split(DOUB_SEPARATOR);
        MNode cur = this.root;
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            return false;
        }
        for (i = 1; i < nodeNames.length - 1; ++i) {
            temp = cur.getChild(nodeNames[i]);
            if (temp == null || temp.isStorageLevel()) {
                return false;
            }
            cur = cur.getChild(nodeNames[i]);
        }
        temp = cur.getChild(nodeNames[i]);
        return temp != null && temp.isStorageLevel();
    }

    private void checkStorageGroup(MNode node) throws PathErrorException {
        if (node.getDataFileName() != null) {
            throw new PathErrorException(String.format("The storage group %s has been set", node.getDataFileName()));
        }
        if (node.getChildren() == null) {
            return;
        }
        for (MNode child : node.getChildren().values()) {
            this.checkStorageGroup(child);
        }
    }

    private void setDataFileName(String path, MNode node) {
        node.setDataFileName(path);
        if (node.getChildren() == null) {
            return;
        }
        for (MNode child : node.getChildren().values()) {
            this.setDataFileName(path, child);
        }
    }

    String deletePath(String path) throws PathErrorException {
        String[] nodes = path.split(DOUB_SEPARATOR);
        if (nodes.length == 0 || !nodes[0].equals(this.getRoot().getName())) {
            throw new PathErrorException("Timeseries %s is not correct." + path);
        }
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                throw new PathErrorException(String.format(NO_CHILD_ERROR, cur.getName(), nodes[i]));
            }
            cur = cur.getChild(nodes[i]);
        }
        String dataFileName = null;
        if (cur.isStorageLevel()) {
            dataFileName = cur.getDataFileName();
        }
        cur.getParent().deleteChild(cur.getName());
        for (cur = cur.getParent(); cur != null && !"root".equals(cur.getName()) && cur.getChildren().size() == 0; cur = cur.getParent()) {
            if (cur.isStorageLevel()) {
                dataFileName = cur.getDataFileName();
                return dataFileName;
            }
            cur.getParent().deleteChild(cur.getName());
        }
        return dataFileName;
    }

    public boolean hasPath(String path) {
        String[] nodes = path.split(DOUB_SEPARATOR);
        if (nodes.length == 0 || !nodes[0].equals(this.getRoot().getName())) {
            return false;
        }
        return this.hasPath(this.getRoot(), nodes, 1);
    }

    private boolean hasPath(MNode node, String[] nodes, int idx) {
        if (idx >= nodes.length) {
            return true;
        }
        if ("*".equals(nodes[idx])) {
            boolean res = false;
            for (MNode child : node.getChildren().values()) {
                res |= this.hasPath(child, nodes, idx + 1);
            }
            return res;
        }
        if (node.hasChild(nodes[idx])) {
            return this.hasPath(node.getChild(nodes[idx]), nodes, idx + 1);
        }
        return false;
    }

    MeasurementSchema getSchemaForOnePath(String path) throws PathErrorException {
        MNode leaf = this.getLeafByPath(path);
        return leaf.getSchema();
    }

    MeasurementSchema getSchemaForOnePath(MNode node, String path) throws PathErrorException {
        MNode leaf = this.getLeafByPath(node, path);
        return leaf.getSchema();
    }

    MeasurementSchema getSchemaForOnePathWithCheck(MNode node, String path) throws PathErrorException {
        MNode leaf = this.getLeafByPathWithCheck(node, path);
        return leaf.getSchema();
    }

    MeasurementSchema getSchemaForOnePathWithCheck(String path) throws PathErrorException {
        MNode leaf = this.getLeafByPathWithCheck(path);
        return leaf.getSchema();
    }

    private MNode getLeafByPath(String path) throws PathErrorException {
        this.checkPath(path);
        String[] node = path.split(DOUB_SEPARATOR);
        MNode cur = this.getRoot();
        for (int i = 1; i < node.length; ++i) {
            cur = cur.getChild(node[i]);
        }
        if (!cur.isLeaf()) {
            throw new PathErrorException(String.format(NOT_LEAF_NODE, path));
        }
        return cur;
    }

    private MNode getLeafByPath(MNode node, String path) throws PathErrorException {
        this.checkPath(node, path);
        String[] nodes = path.split(DOUB_SEPARATOR);
        MNode cur = node.getChild(nodes[0]);
        for (int i = 1; i < nodes.length; ++i) {
            cur = cur.getChild(nodes[i]);
        }
        if (!cur.isLeaf()) {
            throw new PathErrorException(String.format(NOT_LEAF_NODE, path));
        }
        return cur;
    }

    private MNode getLeafByPathWithCheck(MNode node, String path) throws PathErrorException {
        String[] nodes = path.split(DOUB_SEPARATOR);
        if (nodes.length < 1 || !node.hasChild(nodes[0])) {
            throw new PathErrorException(String.format(SERIES_NOT_CORRECT, path));
        }
        MNode cur = node.getChild(nodes[0]);
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                throw new PathErrorException(String.format(NO_CHILD_ERROR, cur.getName(), nodes[i]));
            }
            cur = cur.getChild(nodes[i]);
        }
        if (!cur.isLeaf()) {
            throw new PathErrorException(String.format(NOT_LEAF_NODE, path));
        }
        return cur;
    }

    private MNode getLeafByPathWithCheck(String path) throws PathErrorException {
        String[] nodes = path.split(DOUB_SEPARATOR);
        if (nodes.length < 2 || !nodes[0].equals(this.getRoot().getName())) {
            throw new PathErrorException(String.format(SERIES_NOT_CORRECT, path));
        }
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                throw new PathErrorException(String.format(NO_CHILD_ERROR, cur.getName(), nodes[i]));
            }
            cur = cur.getChild(nodes[i]);
        }
        if (!cur.isLeaf()) {
            throw new PathErrorException(String.format(NOT_LEAF_NODE, path));
        }
        return cur;
    }

    MNode getNodeByPath(String path) throws PathErrorException {
        this.checkPath(path);
        String[] node = path.split(DOUB_SEPARATOR);
        MNode cur = this.getRoot();
        for (int i = 1; i < node.length; ++i) {
            cur = cur.getChild(node[i]);
        }
        return cur;
    }

    MNode getNodeByPathWithFileLevelCheck(String path) throws PathErrorException {
        boolean fileLevelChecked = false;
        String[] nodes = path.split(DOUB_SEPARATOR);
        if (nodes.length < 2 || !nodes[0].equals(this.getRoot().getName())) {
            throw new PathErrorException(String.format(SERIES_NOT_CORRECT, path));
        }
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                throw new PathErrorException(String.format(NO_CHILD_ERROR, cur.getName(), nodes[i]));
            }
            if (!(cur = cur.getChild(nodes[i])).isStorageLevel()) continue;
            fileLevelChecked = true;
        }
        if (!fileLevelChecked) {
            throw new PathErrorException("FileLevel is not set for current seriesPath:" + path);
        }
        return cur;
    }

    String getDeviceTypeByPath(String path) throws PathErrorException {
        this.checkPath(path);
        String[] nodes = path.split(DOUB_SEPARATOR);
        if (nodes.length < 2) {
            throw new PathErrorException(String.format("Timeseries %s must have two or more nodes", path));
        }
        return nodes[0] + "." + nodes[1];
    }

    private MNode checkPath(String path) throws PathErrorException {
        String[] nodes = path.split(DOUB_SEPARATOR);
        if (nodes.length < 2 || !nodes[0].equals(this.getRoot().getName())) {
            throw new PathErrorException(String.format(SERIES_NOT_CORRECT, path));
        }
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                throw new PathErrorException(String.format(NO_CHILD_ERROR, cur.getName(), nodes[i]));
            }
            cur = cur.getChild(nodes[i]);
        }
        return cur;
    }

    private void checkPath(MNode node, String path) throws PathErrorException {
        String[] nodes = path.split(DOUB_SEPARATOR);
        if (nodes.length < 1) {
            return;
        }
        MNode cur = node;
        for (String node1 : nodes) {
            if (!cur.hasChild(node1)) {
                throw new PathErrorException(String.format(NO_CHILD_ERROR, cur.getName(), node1));
            }
            cur = cur.getChild(node1);
        }
    }

    String getStorageGroupNameByPath(String path) throws PathErrorException {
        String[] nodes = path.split(DOUB_SEPARATOR);
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            if (cur == null) {
                throw new PathErrorException(String.format(NOT_SERIES_PATH, path));
            }
            if (cur.isStorageLevel()) {
                return cur.getDataFileName();
            }
            cur = cur.getChild(nodes[i]);
        }
        if (cur.isStorageLevel()) {
            return cur.getDataFileName();
        }
        throw new PathErrorException(String.format(NOT_SERIES_PATH, path));
    }

    List<String> getAllFileNamesByPath(String pathReg) throws PathErrorException {
        ArrayList<String> fileNames = new ArrayList<String>();
        String[] nodes = pathReg.split(DOUB_SEPARATOR);
        if (nodes.length == 0 || !nodes[0].equals(this.getRoot().getName())) {
            throw new PathErrorException(String.format(SERIES_NOT_CORRECT, pathReg));
        }
        this.findFileName(this.getRoot(), nodes, 1, "", fileNames);
        return fileNames;
    }

    private void findFileName(MNode node, String[] nodes, int idx, String parent, ArrayList<String> paths) {
        if (node.isStorageLevel()) {
            paths.add(node.getDataFileName());
            return;
        }
        String nodeReg = idx >= nodes.length ? "*" : nodes[idx];
        if (!"*".equals(nodeReg)) {
            if (node.hasChild(nodeReg)) {
                this.findFileName(node.getChild(nodeReg), nodes, idx + 1, parent + node.getName() + ".", paths);
            }
        } else {
            for (MNode child : node.getChildren().values()) {
                this.findFileName(child, nodes, idx + 1, parent + node.getName() + ".", paths);
            }
        }
    }

    String getStorageGroupNameByPath(MNode node, String path) throws PathErrorException {
        String[] nodes = path.split(DOUB_SEPARATOR);
        MNode cur = node.getChild(nodes[0]);
        for (int i = 1; i < nodes.length; ++i) {
            if (cur == null) {
                throw new PathErrorException(String.format(NOT_SERIES_PATH, path));
            }
            if (cur.isStorageLevel()) {
                return cur.getDataFileName();
            }
            cur = cur.getChild(nodes[i]);
        }
        if (cur.isStorageLevel()) {
            return cur.getDataFileName();
        }
        throw new PathErrorException(String.format(NOT_SERIES_PATH, path));
    }

    boolean checkFileNameByPath(String path) {
        String[] nodes = path.split(DOUB_SEPARATOR);
        MNode cur = this.getRoot();
        for (int i = 1; i <= nodes.length; ++i) {
            if (cur == null) {
                return false;
            }
            if (cur.isStorageLevel()) {
                return true;
            }
            cur = cur.getChild(nodes[i]);
        }
        return false;
    }

    HashMap<String, ArrayList<String>> getAllPath(String pathReg) throws PathErrorException {
        HashMap<String, ArrayList<String>> paths = new HashMap<String, ArrayList<String>>();
        String[] nodes = pathReg.split(DOUB_SEPARATOR);
        if (nodes.length == 0 || !nodes[0].equals(this.getRoot().getName())) {
            throw new PathErrorException(String.format(SERIES_NOT_CORRECT, pathReg));
        }
        this.findPath(this.getRoot(), nodes, 1, "", paths);
        return paths;
    }

    List<List<String>> getShowTimeseriesPath(String pathReg) throws PathErrorException {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        String[] nodes = pathReg.split(DOUB_SEPARATOR);
        if (nodes.length == 0 || !nodes[0].equals(this.getRoot().getName())) {
            throw new PathErrorException(String.format(SERIES_NOT_CORRECT, pathReg));
        }
        this.findPath(this.getRoot(), nodes, 1, "", res);
        return res;
    }

    List<String> getLeafNodePathInNextLevel(String path) throws PathErrorException {
        ArrayList<String> ret = new ArrayList<String>();
        MNode cur = this.checkPath(path);
        for (MNode child : cur.getChildren().values()) {
            if (!child.isLeaf()) continue;
            ret.add(path + "." + child.getName());
        }
        return ret;
    }

    ArrayList<String> getAllPathInList(String path) throws PathErrorException {
        ArrayList<String> res = new ArrayList<String>();
        HashMap<String, ArrayList<String>> mapRet = this.getAllPath(path);
        for (ArrayList<String> value : mapRet.values()) {
            res.addAll(value);
        }
        return res;
    }

    int getFileCountForOneType(String path) throws PathErrorException {
        String[] nodes = path.split(DOUB_SEPARATOR);
        if (nodes.length != 2 || !nodes[0].equals(this.getRoot().getName()) || !this.getRoot().hasChild(nodes[1])) {
            throw new PathErrorException("Timeseries must be " + this.getRoot().getName() + ". X (X is one of the nodes of root's children)");
        }
        return this.getFileCountForOneNode(this.getRoot().getChild(nodes[1]));
    }

    private int getFileCountForOneNode(MNode node) {
        if (node.isStorageLevel()) {
            return 1;
        }
        int sum = 0;
        if (!node.isLeaf()) {
            for (MNode child : node.getChildren().values()) {
                sum += this.getFileCountForOneNode(child);
            }
        }
        return sum;
    }

    ArrayList<String> getAllType() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.getRoot() != null) {
            res.addAll(this.getRoot().getChildren().keySet());
        }
        return res;
    }

    HashSet<String> getAllStorageGroup() {
        HashSet<String> res = new HashSet<String>();
        MNode rootNode = this.getRoot();
        if (rootNode != null) {
            this.findStorageGroup(rootNode, "root", res);
        }
        return res;
    }

    private void findStorageGroup(MNode node, String path, HashSet<String> res) {
        if (node.isStorageLevel()) {
            res.add(path);
            return;
        }
        for (MNode childNode : node.getChildren().values()) {
            this.findStorageGroup(childNode, path + "." + childNode.toString(), res);
        }
    }

    ArrayList<String> getDeviceForOneType(String type) throws PathErrorException {
        String path = this.getRoot().getName() + "." + type;
        this.checkPath(path);
        HashMap<String, Integer> deviceMap = new HashMap<String, Integer>();
        MNode typeNode = this.getRoot().getChild(type);
        this.putDeviceToMap(this.getRoot().getName(), typeNode, deviceMap);
        return new ArrayList<String>(deviceMap.keySet());
    }

    private void putDeviceToMap(String path, MNode node, HashMap<String, Integer> deviceMap) {
        if (node.isLeaf()) {
            deviceMap.put(path, 1);
        } else {
            for (String child : node.getChildren().keySet()) {
                String newPath = path + "." + node.getName();
                this.putDeviceToMap(newPath, node.getChildren().get(child), deviceMap);
            }
        }
    }

    ArrayList<MeasurementSchema> getSchemaForOneType(String path) throws PathErrorException {
        String[] nodes = path.split(DOUB_SEPARATOR);
        if (nodes.length != 2 || !nodes[0].equals(this.getRoot().getName()) || !this.getRoot().hasChild(nodes[1])) {
            throw new PathErrorException("Timeseries must be " + this.getRoot().getName() + ". X (X is one of the nodes of root's children)");
        }
        HashMap<String, MeasurementSchema> leafMap = new HashMap<String, MeasurementSchema>();
        this.putLeafToLeafMap(this.getRoot().getChild(nodes[1]), leafMap);
        return new ArrayList<MeasurementSchema>(leafMap.values());
    }

    ArrayList<MeasurementSchema> getSchemaForOneStorageGroup(String path) {
        String[] nodes = path.split(DOUB_SEPARATOR);
        HashMap<String, MeasurementSchema> leafMap = new HashMap<String, MeasurementSchema>();
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            cur = cur.getChild(nodes[i]);
        }
        this.putLeafToLeafMap(cur, leafMap);
        return new ArrayList<MeasurementSchema>(leafMap.values());
    }

    Map<String, MeasurementSchema> getSchemaMapForOneStorageGroup(String path) {
        String[] nodes = path.split(DOUB_SEPARATOR);
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            cur = cur.getChild(nodes[i]);
        }
        return cur.getSchemaMap();
    }

    Map<String, Integer> getNumSchemaMapForOneFileNode(String path) {
        String[] nodes = path.split(DOUB_SEPARATOR);
        MNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            cur = cur.getChild(nodes[i]);
        }
        return cur.getNumSchemaMap();
    }

    private void putLeafToLeafMap(MNode node, HashMap<String, MeasurementSchema> leafMap) {
        if (node.isLeaf()) {
            if (!leafMap.containsKey(node.getName())) {
                leafMap.put(node.getName(), node.getSchema());
            }
            return;
        }
        for (MNode child : node.getChildren().values()) {
            this.putLeafToLeafMap(child, leafMap);
        }
    }

    private void findPath(MNode node, String[] nodes, int idx, String parent, HashMap<String, ArrayList<String>> paths) {
        if (node.isLeaf()) {
            if (nodes.length <= idx) {
                String fileName = node.getDataFileName();
                String nodePath = parent + node;
                this.putAPath(paths, fileName, nodePath);
            }
            return;
        }
        String nodeReg = idx >= nodes.length ? "*" : nodes[idx];
        if (!"*".equals(nodeReg)) {
            if (node.hasChild(nodeReg)) {
                this.findPath(node.getChild(nodeReg), nodes, idx + 1, parent + node.getName() + ".", paths);
            }
        } else {
            for (MNode child : node.getChildren().values()) {
                this.findPath(child, nodes, idx + 1, parent + node.getName() + ".", paths);
            }
        }
    }

    private void findPath(MNode node, String[] nodes, int idx, String parent, List<List<String>> res) {
        if (node.isLeaf()) {
            if (nodes.length <= idx) {
                String nodePath = parent + node;
                ArrayList<String> tsRow = new ArrayList<String>(4);
                tsRow.add(nodePath);
                MeasurementSchema measurementSchema = node.getSchema();
                tsRow.add(node.getDataFileName());
                tsRow.add(measurementSchema.getType().toString());
                tsRow.add(measurementSchema.getEncodingType().toString());
                res.add(tsRow);
            }
            return;
        }
        String nodeReg = idx >= nodes.length ? "*" : nodes[idx];
        if (!"*".equals(nodeReg)) {
            if (node.hasChild(nodeReg)) {
                this.findPath(node.getChild(nodeReg), nodes, idx + 1, parent + node.getName() + ".", res);
            }
        } else {
            for (MNode child : node.getChildren().values()) {
                this.findPath(child, nodes, idx + 1, parent + node.getName() + ".", res);
            }
        }
    }

    private void putAPath(HashMap<String, ArrayList<String>> paths, String fileName, String nodePath) {
        if (paths.containsKey(fileName)) {
            paths.get(fileName).add(nodePath);
        } else {
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.add(nodePath);
            paths.put(fileName, pathList);
        }
    }

    public String toString() {
        return MTree.jsonToString(this.toJson());
    }

    private static String jsonToString(JSONObject jsonObject) {
        return JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    private JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(this.getRoot().getName(), (Object)this.mnodeToJSON(this.getRoot()));
        return jsonObject;
    }

    private JSONObject mnodeToJSON(MNode node) {
        JSONObject jsonObject = new JSONObject();
        if (!node.isLeaf() && node.getChildren().size() > 0) {
            for (MNode child : node.getChildren().values()) {
                jsonObject.put(child.getName(), (Object)this.mnodeToJSON(child));
            }
        } else if (node.isLeaf()) {
            jsonObject.put("DataType", (Object)node.getSchema().getType());
            jsonObject.put("Encoding", (Object)node.getSchema().getEncodingType());
            jsonObject.put("Compressor", (Object)node.getSchema().getCompressor());
            jsonObject.put("args", (Object)node.getSchema().getProps().toString());
            jsonObject.put("StorageGroup", (Object)node.getDataFileName());
        }
        return jsonObject;
    }

    public MNode getRoot() {
        return this.root;
    }

    static String combineMetadataInStrings(String[] metadatas) {
        JSONObject[] jsonObjects = new JSONObject[metadatas.length];
        for (int i = 0; i < jsonObjects.length; ++i) {
            jsonObjects[i] = JSONObject.parseObject((String)metadatas[i]);
        }
        JSONObject root = jsonObjects[0];
        for (int i = 1; i < jsonObjects.length; ++i) {
            root = MTree.combineJSONObjects(root, jsonObjects[i]);
        }
        return MTree.jsonToString(root);
    }

    private static JSONObject combineJSONObjects(JSONObject a, JSONObject b) {
        JSONObject res = new JSONObject();
        HashSet retainSet = new HashSet(a.keySet());
        retainSet.retainAll(b.keySet());
        HashSet aCha = new HashSet(a.keySet());
        HashSet bCha = new HashSet(b.keySet());
        aCha.removeAll(retainSet);
        bCha.removeAll(retainSet);
        for (String key : aCha) {
            res.put(key, (Object)a.getJSONObject(key));
        }
        for (String key : bCha) {
            res.put(key, b.get((Object)key));
        }
        for (String key : retainSet) {
            Object v1 = a.get((Object)key);
            Object v2 = b.get((Object)key);
            if (v1 instanceof JSONObject && v2 instanceof JSONObject) {
                res.put(key, (Object)MTree.combineJSONObjects((JSONObject)v1, (JSONObject)v2));
                continue;
            }
            res.put(key, v1);
        }
        return res;
    }
}

