/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.MetadataErrorException;
import org.apache.iotdb.db.exception.PathErrorException;
import org.apache.iotdb.db.metadata.MNode;
import org.apache.iotdb.db.metadata.MTree;
import org.apache.iotdb.db.metadata.Metadata;
import org.apache.iotdb.db.metadata.PTree;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MGraph
implements Serializable {
    private static final long serialVersionUID = 8214849219614352834L;
    private static final String DOUB_SEPARATOR = "\\.";
    private static final String TIME_SERIES_INCORRECT = "Timeseries's root is not Correct. RootName: ";
    private MTree mtree;
    private HashMap<String, PTree> ptreeMap;

    MGraph(String mtreeName) {
        this.mtree = new MTree(mtreeName);
        this.ptreeMap = new HashMap();
    }

    void addAPTree(String ptreeRootName) throws MetadataErrorException {
        if ("root".equalsIgnoreCase(ptreeRootName)) {
            throw new MetadataErrorException("Property Tree's root name should not be 'root'");
        }
        PTree ptree = new PTree(ptreeRootName, this.mtree);
        this.ptreeMap.put(ptreeRootName, ptree);
    }

    public void addPathToMTree(String path, String dataType, String encoding) throws PathErrorException {
        TSDataType tsDataType = TSDataType.valueOf((String)dataType);
        TSEncoding tsEncoding = TSEncoding.valueOf((String)encoding);
        CompressionType compressionType = CompressionType.valueOf((String)TSFileConfig.compressor);
        this.addPathToMTree(path, tsDataType, tsEncoding, compressionType, Collections.emptyMap());
    }

    public void addPathToMTree(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws PathErrorException {
        String[] nodes = path.trim().split(DOUB_SEPARATOR);
        if (nodes.length == 0) {
            throw new PathErrorException("Timeseries is null");
        }
        this.mtree.addTimeseriesPath(path, dataType, encoding, compressor, props);
    }

    void addPathToPTree(String path) throws PathErrorException {
        String[] nodes = path.trim().split(DOUB_SEPARATOR);
        if (nodes.length == 0) {
            throw new PathErrorException("Timeseries is null.");
        }
        String rootName = path.trim().split(DOUB_SEPARATOR)[0];
        if (!this.ptreeMap.containsKey(rootName)) {
            throw new PathErrorException(TIME_SERIES_INCORRECT + rootName);
        }
        PTree ptree = this.ptreeMap.get(rootName);
        ptree.addPath(path);
    }

    String deletePath(String path) throws PathErrorException {
        String[] nodes = path.trim().split(DOUB_SEPARATOR);
        if (nodes.length == 0) {
            throw new PathErrorException("Timeseries is null");
        }
        String rootName = path.trim().split(DOUB_SEPARATOR)[0];
        if (this.mtree.getRoot().getName().equals(rootName)) {
            return this.mtree.deletePath(path);
        }
        if (this.ptreeMap.containsKey(rootName)) {
            PTree ptree = this.ptreeMap.get(rootName);
            ptree.deletePath(path);
            return null;
        }
        throw new PathErrorException(TIME_SERIES_INCORRECT + rootName);
    }

    void linkMNodeToPTree(String path, String mpath) throws PathErrorException {
        String ptreeName = path.trim().split(DOUB_SEPARATOR)[0];
        if (!this.ptreeMap.containsKey(ptreeName)) {
            throw new PathErrorException("Error: PTree Path Not Correct. Path: " + path);
        }
        this.ptreeMap.get(ptreeName).linkMNode(path, mpath);
    }

    void unlinkMNodeFromPTree(String path, String mpath) throws PathErrorException {
        String ptreeName = path.trim().split(DOUB_SEPARATOR)[0];
        if (!this.ptreeMap.containsKey(ptreeName)) {
            throw new PathErrorException("Error: PTree Path Not Correct. Path: " + path);
        }
        this.ptreeMap.get(ptreeName).unlinkMNode(path, mpath);
    }

    void setStorageLevel(String path) throws PathErrorException {
        this.mtree.setStorageGroup(path);
    }

    boolean checkStorageLevel(String path) {
        return this.mtree.checkStorageGroup(path);
    }

    HashMap<String, ArrayList<String>> getAllPathGroupByFilename(String path) throws PathErrorException {
        String rootName = path.trim().split(DOUB_SEPARATOR)[0];
        if (this.mtree.getRoot().getName().equals(rootName)) {
            return this.mtree.getAllPath(path);
        }
        if (this.ptreeMap.containsKey(rootName)) {
            PTree ptree = this.ptreeMap.get(rootName);
            return ptree.getAllLinkedPath(path);
        }
        throw new PathErrorException(TIME_SERIES_INCORRECT + rootName);
    }

    List<List<String>> getShowTimeseriesPath(String path) throws PathErrorException {
        String rootName = path.trim().split(DOUB_SEPARATOR)[0];
        if (this.mtree.getRoot().getName().equals(rootName)) {
            return this.mtree.getShowTimeseriesPath(path);
        }
        if (this.ptreeMap.containsKey(rootName)) {
            throw new PathErrorException("PTree is not involved in the execution of the sql 'show timeseries " + path + "'");
        }
        throw new PathErrorException(TIME_SERIES_INCORRECT + rootName);
    }

    Map<String, List<MeasurementSchema>> getSchemaForAllType() throws PathErrorException {
        HashMap<String, List<MeasurementSchema>> res = new HashMap<String, List<MeasurementSchema>>();
        ArrayList<String> typeList = this.mtree.getAllType();
        for (String type : typeList) {
            res.put(type, this.getSchemaForOneType("root." + type));
        }
        return res;
    }

    private ArrayList<String> getDeviceForOneType(String type) throws PathErrorException {
        return this.mtree.getDeviceForOneType(type);
    }

    private Map<String, List<String>> getDeviceForAllType() throws PathErrorException {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        ArrayList<String> types = this.mtree.getAllType();
        for (String type : types) {
            res.put(type, this.getDeviceForOneType(type));
        }
        return res;
    }

    public Metadata getMetadata() throws PathErrorException {
        Map<String, List<String>> deviceIdMap = this.getDeviceForAllType();
        return new Metadata(deviceIdMap);
    }

    HashSet<String> getAllStorageGroup() {
        return this.mtree.getAllStorageGroup();
    }

    List<String> getLeafNodePathInNextLevel(String path) throws PathErrorException {
        return this.mtree.getLeafNodePathInNextLevel(path);
    }

    ArrayList<MeasurementSchema> getSchemaForOneType(String path) throws PathErrorException {
        return this.mtree.getSchemaForOneType(path);
    }

    ArrayList<MeasurementSchema> getSchemaInOneStorageGroup(String path) {
        return this.mtree.getSchemaForOneStorageGroup(path);
    }

    Map<String, MeasurementSchema> getSchemaMapForOneFileNode(String path) {
        return this.mtree.getSchemaMapForOneStorageGroup(path);
    }

    Map<String, Integer> getNumSchemaMapForOneFileNode(String path) {
        return this.mtree.getNumSchemaMapForOneFileNode(path);
    }

    int getFileCountForOneType(String path) throws PathErrorException {
        return this.mtree.getFileCountForOneType(path);
    }

    String getStorageGroupNameByPath(String path) throws PathErrorException {
        return this.mtree.getStorageGroupNameByPath(path);
    }

    String getStorageGroupNameByPath(MNode node, String path) throws PathErrorException {
        return this.mtree.getStorageGroupNameByPath(node, path);
    }

    boolean checkFileNameByPath(String path) {
        return this.mtree.checkFileNameByPath(path);
    }

    List<String> getAllFileNamesByPath(String path) throws PathErrorException {
        return this.mtree.getAllFileNamesByPath(path);
    }

    boolean pathExist(String path) {
        return this.mtree.isPathExist(path);
    }

    boolean pathExist(MNode node, String path) {
        return this.mtree.isPathExist(node, path);
    }

    MNode getNodeByPath(String path) throws PathErrorException {
        return this.mtree.getNodeByPath(path);
    }

    MNode getNodeByPathWithCheck(String path) throws PathErrorException {
        return this.mtree.getNodeByPathWithFileLevelCheck(path);
    }

    public String getDeviceTypeByPath(String path) throws PathErrorException {
        return this.mtree.getDeviceTypeByPath(path);
    }

    MeasurementSchema getSchemaForOnePath(String path) throws PathErrorException {
        return this.mtree.getSchemaForOnePath(path);
    }

    MeasurementSchema getSchemaForOnePath(MNode node, String path) throws PathErrorException {
        return this.mtree.getSchemaForOnePath(node, path);
    }

    MeasurementSchema getSchemaForOnePathWithCheck(MNode node, String path) throws PathErrorException {
        return this.mtree.getSchemaForOnePathWithCheck(node, path);
    }

    MeasurementSchema getSchemaForOnePathWithCheck(String path) throws PathErrorException {
        return this.mtree.getSchemaForOnePathWithCheck(path);
    }

    public String toString() {
        return this.mtree.toString();
    }

    static String combineMetadataInStrings(String[] metadatas) {
        return MTree.combineMetadataInStrings(metadatas);
    }

    Map<String, Integer> countSeriesNumberInEachStorageGroup() throws PathErrorException {
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        HashSet<String> storageGroups = this.getAllStorageGroup();
        for (String sg : storageGroups) {
            this.getNumSchemaMapForOneFileNode(sg);
            MNode node = this.mtree.getNodeByPath(sg);
            res.put(sg, node.getLeafCount());
        }
        return res;
    }
}

