/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.modification.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.io.ModificationReader;
import org.apache.iotdb.db.engine.modification.io.ModificationWriter;
import org.apache.iotdb.tsfile.read.common.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTextModificationAccessor
implements ModificationReader,
ModificationWriter {
    private static final Logger logger = LoggerFactory.getLogger(LocalTextModificationAccessor.class);
    private static final String SEPARATOR = ",";
    private static final String ABORT_MARK = "aborted";
    private String filePath;
    private BufferedWriter writer;

    public LocalTextModificationAccessor(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public Collection<Modification> read() {
        if (!new File(this.filePath).exists()) {
            logger.debug("No modification has been written to this file");
            return new ArrayList<Modification>();
        }
        ArrayList<Modification> modificationList = new ArrayList<Modification>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.filePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.equals(ABORT_MARK) && !modificationList.isEmpty()) {
                    modificationList.remove(modificationList.size() - 1);
                    continue;
                }
                modificationList.add(LocalTextModificationAccessor.decodeModification(line));
            }
        }
        catch (IOException e) {
            logger.error("An error occurred when reading modifications, and the remaining modifications were ignored.", (Throwable)e);
        }
        return modificationList;
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public void abort() throws IOException {
        if (this.writer == null) {
            this.writer = new BufferedWriter(new FileWriter(this.filePath, true));
        }
        this.writer.write(ABORT_MARK);
        this.writer.newLine();
        this.writer.flush();
    }

    @Override
    public void write(Modification mod) throws IOException {
        if (this.writer == null) {
            this.writer = new BufferedWriter(new FileWriter(this.filePath, true));
        }
        this.writer.write(LocalTextModificationAccessor.encodeModification(mod));
        this.writer.newLine();
        this.writer.flush();
    }

    private static String encodeModification(Modification mod) {
        if (mod instanceof Deletion) {
            return LocalTextModificationAccessor.encodeDeletion((Deletion)mod);
        }
        return null;
    }

    private static Modification decodeModification(String src) throws IOException {
        String[] fields = src.split(SEPARATOR);
        if (Modification.Type.DELETION.name().equals(fields[0])) {
            return LocalTextModificationAccessor.decodeDeletion(fields);
        }
        throw new IOException("Unknown modification type: " + fields[0]);
    }

    private static String encodeDeletion(Deletion del) {
        return del.getType().toString() + SEPARATOR + del.getPathString() + SEPARATOR + del.getVersionNum() + SEPARATOR + del.getTimestamp();
    }

    private static Deletion decodeDeletion(String[] fields) throws IOException {
        long timestamp;
        long versionNum;
        if (fields.length != 4) {
            throw new IOException("Incorrect deletion fields number: " + fields.length);
        }
        String path = fields[1];
        try {
            versionNum = Long.parseLong(fields[2]);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid version number: " + fields[2]);
        }
        try {
            timestamp = Long.parseLong(fields[3]);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid timestamp: " + fields[3]);
        }
        return new Deletion(new Path(path), versionNum, timestamp);
    }
}

