/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.db.utils.TsPrimitiveType;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritableMemChunk
implements IWritableMemChunk {
    private static final Logger logger = LoggerFactory.getLogger(WritableMemChunk.class);
    private TSDataType dataType;
    private TVList list;
    private List<TimeValuePair> sortedList;

    public WritableMemChunk(TSDataType dataType, TVList list) {
        this.dataType = dataType;
        this.list = list;
    }

    @Override
    public void write(long insertTime, String insertValue) {
        switch (this.dataType) {
            case BOOLEAN: {
                this.putBoolean(insertTime, Boolean.valueOf(insertValue));
                break;
            }
            case INT32: {
                this.putInt(insertTime, Integer.valueOf(insertValue));
                break;
            }
            case INT64: {
                this.putLong(insertTime, Long.valueOf(insertValue));
                break;
            }
            case FLOAT: {
                this.putFloat(insertTime, Float.valueOf(insertValue).floatValue());
                break;
            }
            case DOUBLE: {
                this.putDouble(insertTime, Double.valueOf(insertValue));
                break;
            }
            case TEXT: {
                this.putBinary(insertTime, Binary.valueOf((String)insertValue));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("Unsupported data type:" + this.dataType);
            }
        }
        this.sortedList = null;
    }

    @Override
    public void write(long insertTime, Object value) {
        switch (this.dataType) {
            case BOOLEAN: {
                this.putBoolean(insertTime, (Boolean)value);
                break;
            }
            case INT32: {
                this.putInt(insertTime, (Integer)value);
                break;
            }
            case INT64: {
                this.putLong(insertTime, (Long)value);
                break;
            }
            case FLOAT: {
                this.putFloat(insertTime, ((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                this.putDouble(insertTime, (Double)value);
                break;
            }
            case TEXT: {
                this.putBinary(insertTime, (Binary)value);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("Unsupported data type:" + this.dataType);
            }
        }
        this.sortedList = null;
    }

    @Override
    public void putLong(long t, long v) {
        this.list.putLong(t, v);
    }

    @Override
    public void putInt(long t, int v) {
        this.list.putInt(t, v);
    }

    @Override
    public void putFloat(long t, float v) {
        this.list.putFloat(t, v);
    }

    @Override
    public void putDouble(long t, double v) {
        this.list.putDouble(t, v);
    }

    @Override
    public void putBinary(long t, Binary v) {
        this.list.putBinary(t, v);
    }

    @Override
    public void putBoolean(long t, boolean v) {
        this.list.putBoolean(t, v);
    }

    @Override
    public synchronized TVList getSortedTVList() {
        this.list.sort();
        return this.list;
    }

    @Override
    public TVList getTVList() {
        return this.list;
    }

    @Override
    public long count() {
        return this.list.size();
    }

    @Override
    public TSDataType getType() {
        return this.dataType;
    }

    @Override
    public void setTimeOffset(long offset) {
        this.list.setTimeOffset(offset);
    }

    @Override
    public synchronized List<TimeValuePair> getSortedTimeValuePairList() {
        if (this.sortedList != null) {
            return this.sortedList;
        }
        this.sortedList = new ArrayList<TimeValuePair>();
        this.list.sort();
        block8: for (int i = 0; i < this.list.size(); ++i) {
            long time = this.list.getTime(i);
            if (time < this.list.getTimeOffset() || i + 1 < this.list.size() && time == this.list.getTime(i + 1)) continue;
            switch (this.dataType) {
                case BOOLEAN: {
                    this.sortedList.add(new TimeValuePair(time, new TsPrimitiveType.TsBoolean(this.list.getBoolean(i))));
                    continue block8;
                }
                case INT32: {
                    this.sortedList.add(new TimeValuePair(time, new TsPrimitiveType.TsInt(this.list.getInt(i))));
                    continue block8;
                }
                case INT64: {
                    this.sortedList.add(new TimeValuePair(time, new TsPrimitiveType.TsLong(this.list.getLong(i))));
                    continue block8;
                }
                case FLOAT: {
                    this.sortedList.add(new TimeValuePair(time, new TsPrimitiveType.TsFloat(this.list.getFloat(i))));
                    continue block8;
                }
                case DOUBLE: {
                    this.sortedList.add(new TimeValuePair(time, new TsPrimitiveType.TsDouble(this.list.getDouble(i))));
                    continue block8;
                }
                case TEXT: {
                    this.sortedList.add(new TimeValuePair(time, new TsPrimitiveType.TsBinary(this.list.getBinary(i))));
                    continue block8;
                }
                default: {
                    logger.error("Unsupported data type: {}", (Object)this.dataType);
                }
            }
        }
        return this.sortedList;
    }

    @Override
    public boolean isEmpty() {
        return this.list.size() == 0;
    }

    @Override
    public long getMinTime() {
        return this.list.getMinTime();
    }

    @Override
    public void delete(long upperBound) {
        this.list.delete(upperBound);
    }
}

