/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.engine.memtable.WritableMemChunk;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.rescon.TVListAllocator;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class AbstractMemTable
implements IMemTable {
    private long version;
    private List<Modification> modifications = new ArrayList<Modification>();
    private final Map<String, Map<String, IWritableMemChunk>> memTableMap;
    private long memSize = 0L;

    public AbstractMemTable() {
        this.memTableMap = new HashMap<String, Map<String, IWritableMemChunk>>();
    }

    public AbstractMemTable(Map<String, Map<String, IWritableMemChunk>> memTableMap) {
        this.memTableMap = memTableMap;
    }

    @Override
    public Map<String, Map<String, IWritableMemChunk>> getMemTableMap() {
        return this.memTableMap;
    }

    private boolean checkPath(String deviceId, String measurement) {
        return this.memTableMap.containsKey(deviceId) && this.memTableMap.get(deviceId).containsKey(measurement);
    }

    private IWritableMemChunk createIfNotExistAndGet(String deviceId, String measurement, TSDataType dataType) {
        Map<String, IWritableMemChunk> memSeries;
        if (!this.memTableMap.containsKey(deviceId)) {
            this.memTableMap.put(deviceId, new HashMap());
        }
        if (!(memSeries = this.memTableMap.get(deviceId)).containsKey(measurement)) {
            memSeries.put(measurement, this.genMemSeries(dataType));
        }
        return memSeries.get(measurement);
    }

    protected abstract IWritableMemChunk genMemSeries(TSDataType var1);

    @Override
    public void insert(InsertPlan insertPlan) {
        for (int i = 0; i < insertPlan.getValues().length; ++i) {
            this.write(insertPlan.getDeviceId(), insertPlan.getMeasurements()[i], insertPlan.getDataTypes()[i], insertPlan.getTime(), insertPlan.getValues()[i]);
        }
        long recordSizeInByte = MemUtils.getRecordSize(insertPlan);
        this.memSize += recordSizeInByte;
    }

    @Override
    public void write(String deviceId, String measurement, TSDataType dataType, long insertTime, String insertValue) {
        IWritableMemChunk memSeries = this.createIfNotExistAndGet(deviceId, measurement, dataType);
        memSeries.write(insertTime, insertValue);
    }

    @Override
    public void write(String deviceId, String measurement, TSDataType dataType, long insertTime, Object value) {
        IWritableMemChunk memSeries = this.createIfNotExistAndGet(deviceId, measurement, dataType);
        memSeries.write(insertTime, value);
    }

    @Override
    public long size() {
        long sum = 0L;
        for (Map<String, IWritableMemChunk> seriesMap : this.memTableMap.values()) {
            for (IWritableMemChunk writableMemChunk : seriesMap.values()) {
                sum += writableMemChunk.count();
            }
        }
        return sum;
    }

    @Override
    public long memSize() {
        return this.memSize;
    }

    @Override
    public void clear() {
        this.memTableMap.clear();
        this.modifications.clear();
        this.memSize = 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.memTableMap.isEmpty();
    }

    @Override
    public ReadOnlyMemChunk query(String deviceId, String measurement, TSDataType dataType, Map<String, String> props) {
        if (!this.checkPath(deviceId, measurement)) {
            return null;
        }
        long undeletedTime = this.findUndeletedTime(deviceId, measurement);
        IWritableMemChunk memChunk = this.memTableMap.get(deviceId).get(measurement);
        WritableMemChunk chunkCopy = new WritableMemChunk(dataType, memChunk.getTVList().clone());
        chunkCopy.setTimeOffset(undeletedTime);
        WritableMemChunk sorter = chunkCopy;
        return new ReadOnlyMemChunk(dataType, sorter, props);
    }

    private long findUndeletedTime(String deviceId, String measurement) {
        long undeletedTime = Long.MIN_VALUE;
        for (Modification modification : this.modifications) {
            Deletion deletion;
            if (!(modification instanceof Deletion) || !(deletion = (Deletion)modification).getDevice().equals(deviceId) || !deletion.getMeasurement().equals(measurement) || deletion.getTimestamp() <= undeletedTime) continue;
            undeletedTime = deletion.getTimestamp();
        }
        return undeletedTime + 1L;
    }

    @Override
    public void delete(String deviceId, String measurementId, long timestamp) {
        Map<String, IWritableMemChunk> deviceMap = this.memTableMap.get(deviceId);
        if (deviceMap != null) {
            IWritableMemChunk chunk = deviceMap.get(measurementId);
            if (chunk == null) {
                return;
            }
            chunk.delete(timestamp);
        }
    }

    @Override
    public void delete(Deletion deletion) {
        this.modifications.add(deletion);
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void release() {
        for (Map.Entry<String, Map<String, IWritableMemChunk>> entry : this.memTableMap.entrySet()) {
            for (Map.Entry<String, IWritableMemChunk> subEntry : entry.getValue().entrySet()) {
                TVListAllocator.getInstance().release(subEntry.getValue().getTVList());
            }
        }
    }
}

