/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.engine.cache.TsFileMetadataUtils;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileMetaDataCache {
    private static final Logger logger = LoggerFactory.getLogger(TsFileMetaDataCache.class);
    private ConcurrentHashMap<String, TsFileMetaData> cache;
    private AtomicLong cacheHintNum = new AtomicLong();
    private AtomicLong cacheRequestNum = new AtomicLong();

    private TsFileMetaDataCache() {
        this.cache = new ConcurrentHashMap();
    }

    public static TsFileMetaDataCache getInstance() {
        return TsFileMetaDataCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TsFileMetaData get(String path) throws IOException {
        String internPath;
        String string = internPath = path.intern();
        synchronized (string) {
            this.cacheRequestNum.incrementAndGet();
            if (!this.cache.containsKey(path)) {
                TsFileMetaData fileMetaData = TsFileMetadataUtils.getTsFileMetaData(path);
                this.cache.put(path, fileMetaData);
                if (logger.isDebugEnabled()) {
                    logger.debug("Cache didn't hint: the number of requests for cache is {}", (Object)this.cacheRequestNum.get());
                }
                return this.cache.get(path);
            }
            this.cacheHintNum.incrementAndGet();
            if (logger.isDebugEnabled()) {
                logger.debug("Cache hint: the number of requests for cache is {}, the number of hints for cache is {}", (Object)this.cacheRequestNum.get(), (Object)this.cacheHintNum.get());
            }
            return this.cache.get(path);
        }
    }

    public void remove(String path) {
        this.cache.remove(path);
    }

    public void clear() {
        this.cache.clear();
    }

    private static class TsFileMetaDataCacheHolder {
        private static final TsFileMetaDataCache INSTANCE = new TsFileMetaDataCache();

        private TsFileMetaDataCacheHolder() {
        }
    }
}

