/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.engine.cache.TsFileMetadataUtils;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceMetaDataCache {
    private static final Logger logger = LoggerFactory.getLogger(DeviceMetaDataCache.class);
    private static final int CACHE_SIZE = 100;
    private LinkedHashMap<String, TsDeviceMetadata> lruCache;
    private AtomicLong cacheHintNum = new AtomicLong();
    private AtomicLong cacheRequestNum = new AtomicLong();

    private DeviceMetaDataCache(int cacheSize) {
        this.lruCache = new LruLinkedHashMap(cacheSize, true);
    }

    public static DeviceMetaDataCache getInstance() {
        return RowGroupBlockMetaDataCacheSingleton.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TsDeviceMetadata get(String filePath, String deviceId, TsFileMetaData fileMetaData) throws IOException {
        String jointPath = filePath + deviceId;
        String jointPathObject = jointPath.intern();
        Object object = this.lruCache;
        synchronized (object) {
            this.cacheRequestNum.incrementAndGet();
            if (this.lruCache.containsKey(jointPath)) {
                this.cacheHintNum.incrementAndGet();
                if (logger.isDebugEnabled()) {
                    logger.debug("Cache hint: the number of requests for cache is {}, the number of hints for cache is {}", (Object)this.cacheRequestNum.get(), (Object)this.cacheHintNum.get());
                }
                return this.lruCache.get(jointPath);
            }
        }
        object = jointPathObject;
        synchronized (object) {
            LinkedHashMap<String, TsDeviceMetadata> linkedHashMap = this.lruCache;
            synchronized (linkedHashMap) {
                if (this.lruCache.containsKey(jointPath)) {
                    return this.lruCache.get(jointPath);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Cache didn't hint: the number of requests for cache is {}", (Object)this.cacheRequestNum.get());
            }
            TsDeviceMetadata blockMetaData = TsFileMetadataUtils.getTsRowGroupBlockMetaData(filePath, deviceId, fileMetaData);
            LinkedHashMap<String, TsDeviceMetadata> linkedHashMap2 = this.lruCache;
            synchronized (linkedHashMap2) {
                this.lruCache.put(jointPath, blockMetaData);
                return this.lruCache.get(jointPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedHashMap<String, TsDeviceMetadata> linkedHashMap = this.lruCache;
        synchronized (linkedHashMap) {
            this.lruCache.clear();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceMetaDataCache that = (DeviceMetaDataCache)o;
        return Objects.equals(this.lruCache, that.lruCache) && Objects.equals(this.cacheHintNum, that.cacheHintNum) && Objects.equals(this.cacheRequestNum, that.cacheRequestNum);
    }

    public int hashCode() {
        return Objects.hash(this.lruCache, this.cacheHintNum, this.cacheRequestNum);
    }

    private class LruLinkedHashMap
    extends LinkedHashMap<String, TsDeviceMetadata> {
        private static final long serialVersionUID = 1290160928914532649L;
        private static final float LOAD_FACTOR_MAP = 0.75f;
        private int maxCapacity;

        public LruLinkedHashMap(int maxCapacity, boolean isLru) {
            super(maxCapacity, 0.75f, isLru);
            this.maxCapacity = maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, TsDeviceMetadata> eldest) {
            return this.size() > this.maxCapacity;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class RowGroupBlockMetaDataCacheSingleton {
        private static final DeviceMetaDataCache INSTANCE = new DeviceMetaDataCache(100);

        private RowGroupBlockMetaDataCacheSingleton() {
        }
    }
}

