/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.directories.strategy;

import java.util.List;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirectoryStrategy {
    protected static final Logger logger = LoggerFactory.getLogger(DirectoryStrategy.class);
    protected List<String> folders;

    public void init(List<String> folders) throws DiskSpaceInsufficientException {
        this.folders = folders;
        boolean hasSpace = false;
        for (String folder : folders) {
            if (!CommonUtils.hasSpace(folder)) continue;
            hasSpace = true;
            break;
        }
        if (!hasSpace) {
            throw new DiskSpaceInsufficientException(String.format("All disks of folders %s are full, can't init.", folders));
        }
    }

    public abstract int nextFolderIndex() throws DiskSpaceInsufficientException;

    public String getTsFileFolder(int index) {
        return this.folders.get(index);
    }

    public String getFolderForTest() {
        return this.getTsFileFolder(0);
    }

    public void setFolderForTest(String path) {
        this.folders.set(0, path);
    }
}

