/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.Properties;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBDescriptor.class);
    private IoTDBConfig conf = new IoTDBConfig();

    private IoTDBDescriptor() {
        this.loadProps();
    }

    public static IoTDBDescriptor getInstance() {
        return IoTDBDescriptorHolder.INSTANCE;
    }

    public IoTDBConfig getConfig() {
        return this.conf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getPropsUrl() {
        String url = System.getProperty("IOTDB_CONF", null);
        if (url != null) return url + File.separatorChar + "iotdb-engine.properties";
        url = System.getProperty("IOTDB_HOME", null);
        if (url != null) {
            return url + File.separatorChar + "conf" + File.separatorChar + "iotdb-engine.properties";
        }
        logger.warn("Cannot find IOTDB_HOME or IOTDB_CONF environment variable when loading config file {}, use default configuration", (Object)"iotdb-engine.properties");
        this.conf.updatePath();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        FileInputStream inputStream;
        String url = this.getPropsUrl();
        if (url == null) {
            return;
        }
        try {
            inputStream = new FileInputStream(new File(url));
        }
        catch (FileNotFoundException e) {
            logger.warn("Fail to find config file {}", (Object)url, (Object)e);
            this.conf.updatePath();
            return;
        }
        logger.info("Start to read config file {}", (Object)url);
        Properties properties = new Properties();
        try {
            long memTableSizeThreshold;
            properties.load(inputStream);
            this.conf.setEnableStatMonitor(Boolean.parseBoolean(properties.getProperty("enable_stat_monitor", Boolean.toString(this.conf.isEnableStatMonitor()))));
            this.conf.setBackLoopPeriodSec(Integer.parseInt(properties.getProperty("back_loop_period_in_second", Integer.toString(this.conf.getBackLoopPeriodSec()))));
            int statMonitorDetectFreqSec = Integer.parseInt(properties.getProperty("stat_monitor_detect_freq_in_second", Integer.toString(this.conf.getStatMonitorDetectFreqSec())));
            int statMonitorRetainIntervalSec = Integer.parseInt(properties.getProperty("stat_monitor_retain_interval_in_second", Integer.toString(this.conf.getStatMonitorRetainIntervalSec())));
            if (this.conf.getStatMonitorDetectFreqSec() < statMonitorDetectFreqSec) {
                this.conf.setStatMonitorDetectFreqSec(statMonitorDetectFreqSec);
            } else {
                logger.info("The stat_monitor_detect_freq_sec value is smaller than default, use default value");
            }
            if (this.conf.getStatMonitorRetainIntervalSec() < statMonitorRetainIntervalSec) {
                this.conf.setStatMonitorRetainIntervalSec(statMonitorRetainIntervalSec);
            } else {
                logger.info("The stat_monitor_retain_interval_sec value is smaller than default, use default value");
            }
            this.conf.setRpcAddress(properties.getProperty("rpc_address", this.conf.getRpcAddress()));
            this.conf.setRpcPort(Integer.parseInt(properties.getProperty("rpc_port", Integer.toString(this.conf.getRpcPort()))));
            this.conf.setEnableParameterAdapter(Boolean.parseBoolean(properties.getProperty("enable_parameter_adapter", Boolean.toString(this.conf.isEnableParameterAdapter()))));
            this.initMemoryAllocate(properties);
            this.conf.setEnableWal(Boolean.parseBoolean(properties.getProperty("enable_wal", Boolean.toString(this.conf.isEnableWal()))));
            this.conf.setBaseDir(properties.getProperty("base_dir", this.conf.getBaseDir()));
            this.conf.setSystemDir(FilePathUtils.regularizePath(this.conf.getBaseDir()) + "system");
            this.conf.setDataDirs(properties.getProperty("data_dirs", this.conf.getDataDirs()[0]).split(","));
            this.conf.setWalFolder(properties.getProperty("wal_dir", this.conf.getWalFolder()));
            this.conf.setFlushWalThreshold(Integer.parseInt(properties.getProperty("flush_wal_threshold", Integer.toString(this.conf.getFlushWalThreshold()))));
            this.conf.setForceWalPeriodInMs(Long.parseLong(properties.getProperty("force_wal_period_in_ms", Long.toString(this.conf.getForceWalPeriodInMs()))));
            int walBufferSize = Integer.parseInt(properties.getProperty("wal_buffer_size", Integer.toString(this.conf.getWalBufferSize())));
            if (walBufferSize > 0) {
                this.conf.setWalBufferSize(walBufferSize);
            }
            this.conf.setMultiDirStrategyClassName(properties.getProperty("multi_dir_strategy", this.conf.getMultiDirStrategyClassName()));
            this.conf.setMergeConcurrentThreads(Integer.parseInt(properties.getProperty("merge_concurrent_threads", Integer.toString(this.conf.getMergeConcurrentThreads()))));
            if (this.conf.getMergeConcurrentThreads() <= 0 || this.conf.getMergeConcurrentThreads() > Runtime.getRuntime().availableProcessors()) {
                this.conf.setMergeConcurrentThreads(Runtime.getRuntime().availableProcessors());
            }
            this.conf.setFetchSize(Integer.parseInt(properties.getProperty("fetch_size", Integer.toString(this.conf.getFetchSize()))));
            long tsfileSizeThreshold = Long.parseLong(properties.getProperty("tsfile_size_threshold", Long.toString(this.conf.getTsFileSizeThreshold())).trim());
            if (tsfileSizeThreshold > 0L) {
                this.conf.setTsFileSizeThreshold(tsfileSizeThreshold);
            }
            if ((memTableSizeThreshold = Long.parseLong(properties.getProperty("memtable_size_threshold", Long.toString(this.conf.getMemtableSizeThreshold())).trim())) > 0L) {
                this.conf.setMemtableSizeThreshold(memTableSizeThreshold);
            }
            this.conf.setSyncEnable(Boolean.parseBoolean(properties.getProperty("is_sync_enable", Boolean.toString(this.conf.isSyncEnable()))));
            this.conf.setSyncServerPort(Integer.parseInt(properties.getProperty("sync_server_port", Integer.toString(this.conf.getSyncServerPort())).trim()));
            this.conf.setUpdateHistoricalDataPossibility(Boolean.parseBoolean(properties.getProperty("update_historical_data_possibility", Boolean.toString(this.conf.isSyncEnable()))));
            this.conf.setIpWhiteList(properties.getProperty("ip_white_list", this.conf.getIpWhiteList()));
            this.conf.setConcurrentFlushThread(Integer.parseInt(properties.getProperty("concurrent_flush_thread", Integer.toString(this.conf.getConcurrentFlushThread()))));
            if (this.conf.getConcurrentFlushThread() <= 0) {
                this.conf.setConcurrentFlushThread(Runtime.getRuntime().availableProcessors());
            }
            this.conf.setmManagerCacheSize(Integer.parseInt(properties.getProperty("schema_manager_cache_size", Integer.toString(this.conf.getmManagerCacheSize())).trim()));
            this.conf.setLanguageVersion(properties.getProperty("language_version", this.conf.getLanguageVersion()).trim());
            if (properties.containsKey("chunk_buffer_pool_enable")) {
                this.conf.setChunkBufferPoolEnable(Boolean.parseBoolean(properties.getProperty("chunk_buffer_pool_enable")));
            }
            String tmpTimeZone = properties.getProperty("time_zone", this.conf.getZoneID().toString());
            this.conf.setZoneID(ZoneId.of(tmpTimeZone.trim()));
            logger.info("Time zone has been set to {}", (Object)this.conf.getZoneID());
            this.conf.setEnablePerformanceStat(Boolean.parseBoolean(properties.getProperty("enable_performance_stat", Boolean.toString(this.conf.isEnablePerformanceStat())).trim()));
            this.conf.setPerformanceStatDisplayInterval(Long.parseLong(properties.getProperty("performance_stat_display_interval", Long.toString(this.conf.getPerformanceStatDisplayInterval())).trim()));
            this.conf.setPerformanceStatMemoryInKB(Integer.parseInt(properties.getProperty("performance_stat_memory_in_kb", Integer.toString(this.conf.getPerformanceStatMemoryInKB())).trim()));
        }
        catch (IOException e) {
            logger.warn("Cannot load config file because, use default configuration", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Incorrect format in config file, use default configuration", (Throwable)e);
        }
        finally {
            this.conf.updatePath();
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                logger.error("Fail to close config file input stream because ", (Throwable)e);
            }
        }
    }

    private void initMemoryAllocate(Properties properties) {
        String memoryAllocateProportion = properties.getProperty("write_read_free_memory_proportion");
        if (memoryAllocateProportion != null) {
            String[] proportions = memoryAllocateProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            long maxMemoryAvailable = Runtime.getRuntime().maxMemory();
            this.conf.setAllocateMemoryForWrite(maxMemoryAvailable * (long)Integer.parseInt(proportions[0].trim()) / (long)proportionSum);
            this.conf.setAllocateMemoryForRead(maxMemoryAvailable * (long)Integer.parseInt(proportions[1].trim()) / (long)proportionSum);
        }
    }

    private static class IoTDBDescriptorHolder {
        private static final IoTDBDescriptor INSTANCE = new IoTDBDescriptor();

        private IoTDBDescriptorHolder() {
        }
    }
}

