/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.chunk;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.tsfile.exception.write.NoMeasurementException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.footer.ChunkGroupFooter;
import org.apache.iotdb.tsfile.write.chunk.ChunkBuffer;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkGroupWriter;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkGroupWriterImpl
implements IChunkGroupWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkGroupWriterImpl.class);
    private final String deviceId;
    private Map<String, IChunkWriter> chunkWriters = new HashMap<String, IChunkWriter>();

    public ChunkGroupWriterImpl(String deviceId) {
        this.deviceId = deviceId;
    }

    @Override
    public void addSeriesWriter(MeasurementSchema schema, int pageSizeThreshold) {
        if (!this.chunkWriters.containsKey(schema.getMeasurementId())) {
            ChunkBuffer chunkBuffer = new ChunkBuffer(schema);
            ChunkWriterImpl seriesWriter = new ChunkWriterImpl(schema, chunkBuffer, pageSizeThreshold);
            this.chunkWriters.put(schema.getMeasurementId(), seriesWriter);
        }
    }

    @Override
    public void write(long time, List<DataPoint> data) throws WriteProcessException, IOException {
        for (DataPoint point : data) {
            String measurementId = point.getMeasurementId();
            if (!this.chunkWriters.containsKey(measurementId)) {
                throw new NoMeasurementException("time " + time + ", measurement id " + measurementId + " not found!");
            }
            point.writeTo(time, this.chunkWriters.get(measurementId));
        }
    }

    @Override
    public ChunkGroupFooter flushToFileWriter(TsFileIOWriter fileWriter) throws IOException {
        LOG.debug("start flush device id:{}", (Object)this.deviceId);
        this.sealAllChunks();
        ChunkGroupFooter footer = new ChunkGroupFooter(this.deviceId, this.getCurrentChunkGroupSize(), this.getSeriesNumber());
        for (IChunkWriter seriesWriter : this.chunkWriters.values()) {
            seriesWriter.writeToFileWriter(fileWriter);
        }
        return footer;
    }

    @Override
    public long updateMaxGroupMemSize() {
        long bufferSize = 0L;
        for (IChunkWriter seriesWriter : this.chunkWriters.values()) {
            bufferSize += seriesWriter.estimateMaxSeriesMemSize();
        }
        return bufferSize;
    }

    @Override
    public long getCurrentChunkGroupSize() {
        long size = 0L;
        for (IChunkWriter writer : this.chunkWriters.values()) {
            size += writer.getCurrentChunkSize();
        }
        return size;
    }

    private void sealAllChunks() {
        for (IChunkWriter writer : this.chunkWriters.values()) {
            writer.sealCurrentPage();
        }
    }

    @Override
    public int getSeriesNumber() {
        return this.chunkWriters.size();
    }
}

