/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.enums.TSFreqType;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.BytesUtils;

public class ReadWriteIOUtils {
    private static final int SHORT_LEN = 2;
    private static final int INT_LEN = 4;
    private static final int LONG_LEN = 8;
    private static final int DOUBLE_LEN = 8;
    private static final int FLOAT_LEN = 4;

    private ReadWriteIOUtils() {
    }

    public static boolean readBool(InputStream inputStream) throws IOException {
        int flag = inputStream.read();
        return flag == 1;
    }

    public static boolean readBool(ByteBuffer buffer) {
        byte a = buffer.get();
        return a == 1;
    }

    public static int writeIsNull(Object object, OutputStream outputStream) throws IOException {
        return ReadWriteIOUtils.write((Boolean)(object != null ? 1 : 0), outputStream);
    }

    public static int writeIsNull(Object object, ByteBuffer buffer) {
        return ReadWriteIOUtils.write((Boolean)(object != null ? 1 : 0), buffer);
    }

    public static boolean readIsNull(InputStream inputStream) throws IOException {
        return ReadWriteIOUtils.readBool(inputStream);
    }

    public static boolean readIsNull(ByteBuffer buffer) {
        return ReadWriteIOUtils.readBool(buffer);
    }

    public static int write(Boolean flag, OutputStream outputStream) throws IOException {
        if (flag.booleanValue()) {
            outputStream.write(1);
        } else {
            outputStream.write(0);
        }
        return 1;
    }

    public static int write(Boolean flag, ByteBuffer buffer) {
        byte a = flag != false ? (byte)1 : 0;
        buffer.put(a);
        return 1;
    }

    public static int write(byte n, OutputStream outputStream) throws IOException {
        outputStream.write(n);
        return 1;
    }

    public static int write(short n, OutputStream outputStream) throws IOException {
        byte[] bytes = BytesUtils.shortToBytes(n);
        outputStream.write(bytes);
        return bytes.length;
    }

    public static int write(byte n, ByteBuffer buffer) {
        buffer.put(n);
        return 1;
    }

    public static int write(short n, ByteBuffer buffer) {
        buffer.putShort(n);
        return 2;
    }

    public static int write(int n, OutputStream outputStream) throws IOException {
        byte[] bytes = BytesUtils.intToBytes(n);
        outputStream.write(bytes);
        return bytes.length;
    }

    public static int write(int n, ByteBuffer buffer) {
        buffer.putInt(n);
        return 4;
    }

    public static int write(float n, OutputStream outputStream) throws IOException {
        byte[] bytes = BytesUtils.floatToBytes(n);
        outputStream.write(bytes);
        return 4;
    }

    public static int write(double n, OutputStream outputStream) throws IOException {
        byte[] bytes = BytesUtils.doubleToBytes(n);
        outputStream.write(bytes);
        return 8;
    }

    public static int write(long n, OutputStream outputStream) throws IOException {
        byte[] bytes = BytesUtils.longToBytes(n);
        outputStream.write(bytes);
        return bytes.length;
    }

    public static int write(long n, ByteBuffer buffer) {
        buffer.putLong(n);
        return 8;
    }

    public static int write(String s, OutputStream outputStream) throws IOException {
        int len = 0;
        byte[] bytes = s.getBytes();
        len += ReadWriteIOUtils.write(bytes.length, outputStream);
        outputStream.write(bytes);
        return len += bytes.length;
    }

    public static int write(String s, ByteBuffer buffer) {
        int len = 0;
        byte[] bytes = s.getBytes();
        len += ReadWriteIOUtils.write(bytes.length, buffer);
        buffer.put(bytes);
        return len += bytes.length;
    }

    public static int write(ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        int len = 0;
        len += ReadWriteIOUtils.write(byteBuffer.capacity(), outputStream);
        byte[] bytes = byteBuffer.array();
        outputStream.write(bytes);
        return len += bytes.length;
    }

    public static int write(ByteBuffer byteBuffer, ByteBuffer buffer) {
        int len = 0;
        len += ReadWriteIOUtils.write(byteBuffer.capacity(), buffer);
        byte[] bytes = byteBuffer.array();
        buffer.put(bytes);
        return len += bytes.length;
    }

    public static int write(CompressionType compressionType, OutputStream outputStream) throws IOException {
        short n = compressionType.serialize();
        return ReadWriteIOUtils.write(n, outputStream);
    }

    public static int write(CompressionType compressionType, ByteBuffer buffer) {
        short n = compressionType.serialize();
        return ReadWriteIOUtils.write(n, buffer);
    }

    public static int write(TSDataType dataType, OutputStream outputStream) throws IOException {
        short n = dataType.serialize();
        return ReadWriteIOUtils.write(n, outputStream);
    }

    public static int write(TSDataType dataType, ByteBuffer buffer) {
        short n = dataType.serialize();
        return ReadWriteIOUtils.write(n, buffer);
    }

    public static int write(TSEncoding encoding, OutputStream outputStream) throws IOException {
        short n = encoding.serialize();
        return ReadWriteIOUtils.write(n, outputStream);
    }

    public static int write(TSEncoding encoding, ByteBuffer buffer) {
        short n = encoding.serialize();
        return ReadWriteIOUtils.write(n, buffer);
    }

    public static int write(TSFreqType freqType, OutputStream outputStream) throws IOException {
        short n = freqType.serialize();
        return ReadWriteIOUtils.write(n, outputStream);
    }

    public static int write(TSFreqType freqType, ByteBuffer buffer) {
        short n = freqType.serialize();
        return ReadWriteIOUtils.write(n, buffer);
    }

    public static short readShort(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[2];
        int readLen = inputStream.read(bytes);
        if (readLen != 2) {
            throw new IOException(String.format("Intend to read %d bytes but %d are actually returned", 2, readLen));
        }
        return BytesUtils.bytesToShort(bytes);
    }

    public static short readShort(ByteBuffer buffer) {
        return buffer.getShort();
    }

    public static float readFloat(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[4];
        int readLen = inputStream.read(bytes);
        if (readLen != 4) {
            throw new IOException(String.format("Intend to read %d bytes but %d are actually returned", 4, readLen));
        }
        return BytesUtils.bytesToFloat(bytes);
    }

    public static float readFloat(ByteBuffer byteBuffer) {
        byte[] bytes = new byte[4];
        byteBuffer.get(bytes);
        return BytesUtils.bytesToFloat(bytes);
    }

    public static double readDouble(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[8];
        int readLen = inputStream.read(bytes);
        if (readLen != 8) {
            throw new IOException(String.format("Intend to read %d bytes but %d are actually returned", 8, readLen));
        }
        return BytesUtils.bytesToDouble(bytes);
    }

    public static double readDouble(ByteBuffer byteBuffer) {
        byte[] bytes = new byte[8];
        byteBuffer.get(bytes);
        return BytesUtils.bytesToDouble(bytes);
    }

    public static int readInt(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[4];
        int readLen = inputStream.read(bytes);
        if (readLen != 4) {
            throw new IOException(String.format("Intend to read %d bytes but %d are actually returned", 4, readLen));
        }
        return BytesUtils.bytesToInt(bytes);
    }

    public static int readInt(ByteBuffer buffer) {
        return buffer.getInt();
    }

    public static int read(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return -1;
        }
        return buffer.get() & 0xFF;
    }

    public static long readLong(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[8];
        int readLen = inputStream.read(bytes);
        if (readLen != 8) {
            throw new IOException(String.format("Intend to read %d bytes but %d are actually returned", 8, readLen));
        }
        return BytesUtils.bytesToLong(bytes);
    }

    public static long readLong(ByteBuffer buffer) {
        return buffer.getLong();
    }

    public static String readString(InputStream inputStream) throws IOException {
        int strLength = ReadWriteIOUtils.readInt(inputStream);
        byte[] bytes = new byte[strLength];
        int readLen = inputStream.read(bytes, 0, strLength);
        if (readLen != strLength) {
            throw new IOException(String.format("Intend to read %d bytes but %d are actually returned", strLength, readLen));
        }
        return new String(bytes, 0, strLength);
    }

    public static String readString(ByteBuffer buffer) {
        int strLength = ReadWriteIOUtils.readInt(buffer);
        byte[] bytes = new byte[strLength];
        buffer.get(bytes, 0, strLength);
        return new String(bytes, 0, strLength);
    }

    public static String readStringWithoutLength(ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes, 0, length);
        return new String(bytes, 0, length);
    }

    public static ByteBuffer getByteBuffer(String s) {
        return ByteBuffer.wrap(s.getBytes(StandardCharsets.UTF_8));
    }

    public static ByteBuffer getByteBuffer(int i) {
        return ByteBuffer.allocate(4).putInt(0, i);
    }

    public static ByteBuffer getByteBuffer(long n) {
        return ByteBuffer.allocate(8).putLong(0, n);
    }

    public static ByteBuffer getByteBuffer(float f) {
        return ByteBuffer.allocate(4).putFloat(0, f);
    }

    public static ByteBuffer getByteBuffer(double d) {
        return ByteBuffer.allocate(8).putDouble(0, d);
    }

    public static ByteBuffer getByteBuffer(boolean i) {
        return ByteBuffer.allocate(1).put(i ? (byte)1 : 0);
    }

    public static String readStringFromDirectByteBuffer(ByteBuffer buffer) throws CharacterCodingException {
        return StandardCharsets.UTF_8.newDecoder().decode(buffer.duplicate()).toString();
    }

    public static byte[] readBytes(InputStream inputStream, int length) throws IOException {
        byte[] bytes = new byte[length];
        int offset = 0;
        int len = 0;
        while (bytes.length - offset > 0 && (len = inputStream.read(bytes, offset, bytes.length - offset)) != -1) {
            offset += len;
        }
        return bytes;
    }

    public static byte[] readBytesWithSelfDescriptionLength(InputStream inputStream) throws IOException {
        int length = ReadWriteIOUtils.readInt(inputStream);
        return ReadWriteIOUtils.readBytes(inputStream, length);
    }

    public static ByteBuffer readByteBufferWithSelfDescriptionLength(InputStream inputStream) throws IOException {
        byte[] bytes = ReadWriteIOUtils.readBytesWithSelfDescriptionLength(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
        byteBuffer.put(bytes);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static ByteBuffer readByteBufferWithSelfDescriptionLength(ByteBuffer buffer) {
        int byteLength = ReadWriteIOUtils.readInt(buffer);
        byte[] bytes = new byte[byteLength];
        buffer.get(bytes);
        ByteBuffer byteBuffer = ByteBuffer.allocate(byteLength);
        byteBuffer.put(bytes);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static int readAsPossible(TsFileInput input, long position, ByteBuffer buffer) throws IOException {
        int read;
        int length = 0;
        while (buffer.hasRemaining() && (read = input.read(buffer, position)) != -1) {
            length += read;
            input.read(buffer, position += (long)read);
        }
        return length;
    }

    public static int readAsPossible(TsFileInput input, ByteBuffer buffer) throws IOException {
        int read;
        int length = 0;
        while (buffer.hasRemaining() && (read = input.read(buffer)) != -1) {
            length += read;
        }
        return length;
    }

    public static int readAsPossible(TsFileInput input, ByteBuffer target, long offset, int len) throws IOException {
        int read;
        int length = 0;
        int limit = target.limit();
        if (target.remaining() > len) {
            target.limit(target.position() + len);
        }
        while (length < len && target.hasRemaining() && (read = input.read(target, offset)) != -1) {
            length += read;
            offset += (long)read;
        }
        target.limit(limit);
        return length;
    }

    public static List<Integer> readIntegerList(InputStream inputStream) throws IOException {
        int size = ReadWriteIOUtils.readInt(inputStream);
        if (size <= 0) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            list.add(ReadWriteIOUtils.readInt(inputStream));
        }
        return list;
    }

    public static List<Integer> readIntegerList(ByteBuffer buffer) {
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size <= 0) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            list.add(ReadWriteIOUtils.readInt(buffer));
        }
        return list;
    }

    public static List<String> readStringList(InputStream inputStream) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        int size = ReadWriteIOUtils.readInt(inputStream);
        for (int i = 0; i < size; ++i) {
            list.add(ReadWriteIOUtils.readString(inputStream));
        }
        return list;
    }

    public static List<String> readStringList(ByteBuffer buffer) {
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size <= 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            list.add(ReadWriteIOUtils.readString(buffer));
        }
        return list;
    }

    public static CompressionType readCompressionType(InputStream inputStream) throws IOException {
        short n = ReadWriteIOUtils.readShort(inputStream);
        return CompressionType.deserialize(n);
    }

    public static CompressionType readCompressionType(ByteBuffer buffer) {
        short n = ReadWriteIOUtils.readShort(buffer);
        return CompressionType.deserialize(n);
    }

    public static TSDataType readDataType(InputStream inputStream) throws IOException {
        short n = ReadWriteIOUtils.readShort(inputStream);
        return TSDataType.deserialize(n);
    }

    public static TSDataType readDataType(ByteBuffer buffer) {
        short n = ReadWriteIOUtils.readShort(buffer);
        return TSDataType.deserialize(n);
    }

    public static TSEncoding readEncoding(InputStream inputStream) throws IOException {
        short n = ReadWriteIOUtils.readShort(inputStream);
        return TSEncoding.deserialize(n);
    }

    public static TSEncoding readEncoding(ByteBuffer buffer) {
        short n = ReadWriteIOUtils.readShort(buffer);
        return TSEncoding.deserialize(n);
    }

    public static TSFreqType readFreqType(InputStream inputStream) throws IOException {
        short n = ReadWriteIOUtils.readShort(inputStream);
        return TSFreqType.deserialize(n);
    }

    public static TSFreqType readFreqType(ByteBuffer buffer) {
        short n = ReadWriteIOUtils.readShort(buffer);
        return TSFreqType.deserialize(n);
    }
}

