/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.timegenerator.node;

import java.io.IOException;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.Node;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.NodeType;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReader;

public class LeafNode
implements Node {
    private FileSeriesReader reader;
    private BatchData data = null;
    private boolean gotData = false;

    public LeafNode(FileSeriesReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.gotData) {
            this.data.next();
            this.gotData = false;
        }
        if (this.data == null || !this.data.hasNext()) {
            if (this.reader.hasNextBatch()) {
                this.data = this.reader.nextBatch();
            } else {
                return false;
            }
        }
        return this.data.hasNext();
    }

    @Override
    public long next() {
        long time = this.data.currentTime();
        this.gotData = true;
        return time;
    }

    public boolean currentTimeIs(long time) {
        if (!this.reader.currentBatch().hasNext()) {
            return false;
        }
        return this.reader.currentBatch().currentTime() == time;
    }

    public Object currentValue(long time) {
        if (this.data.currentTime() == time) {
            return this.data.currentValue();
        }
        return null;
    }

    @Override
    public NodeType getType() {
        return NodeType.LEAF;
    }
}

