/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.exception.write.NoMeasurementException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.controller.ChunkLoader;
import org.apache.iotdb.tsfile.read.controller.MetadataQuerier;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.expression.util.ExpressionOptimizer;
import org.apache.iotdb.tsfile.read.query.dataset.DataSetWithoutTimeGenerator;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.executor.ExecutorWithTimeGenerator;
import org.apache.iotdb.tsfile.read.query.executor.QueryExecutor;
import org.apache.iotdb.tsfile.read.reader.series.EmptyFileSeriesReader;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReader;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReaderWithFilter;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReaderWithoutFilter;

public class TsFileExecutor
implements QueryExecutor {
    private MetadataQuerier metadataQuerier;
    private ChunkLoader chunkLoader;

    public TsFileExecutor(MetadataQuerier metadataQuerier, ChunkLoader chunkLoader) {
        this.metadataQuerier = metadataQuerier;
        this.chunkLoader = chunkLoader;
    }

    @Override
    public QueryDataSet execute(QueryExpression queryExpression) throws IOException {
        this.metadataQuerier.loadChunkMetaDatas(queryExpression.getSelectedSeries());
        if (queryExpression.hasQueryFilter()) {
            try {
                IExpression expression = queryExpression.getExpression();
                IExpression regularIExpression = ExpressionOptimizer.getInstance().optimize(expression, queryExpression.getSelectedSeries());
                queryExpression.setExpression(regularIExpression);
                if (regularIExpression instanceof GlobalTimeExpression) {
                    return this.execute(queryExpression.getSelectedSeries(), (GlobalTimeExpression)regularIExpression);
                }
                return new ExecutorWithTimeGenerator(this.metadataQuerier, this.chunkLoader).execute(queryExpression);
            }
            catch (QueryFilterOptimizationException | NoMeasurementException e) {
                throw new IOException(e);
            }
        }
        try {
            return this.execute(queryExpression.getSelectedSeries());
        }
        catch (NoMeasurementException e) {
            throw new IOException(e);
        }
    }

    public QueryDataSet execute(QueryExpression queryExpression, long spacePartitionStartPos, long spacePartitionEndPos) throws IOException {
        ArrayList<TimeRange> resTimeRanges = new ArrayList<TimeRange>(this.metadataQuerier.convertSpace2TimePartition(queryExpression.getSelectedSeries(), spacePartitionStartPos, spacePartitionEndPos));
        if (resTimeRanges.isEmpty()) {
            return new DataSetWithoutTimeGenerator(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        IExpression addTimeExpression = resTimeRanges.get(0).getExpression();
        for (int i = 1; i < resTimeRanges.size(); ++i) {
            addTimeExpression = BinaryExpression.or(addTimeExpression, resTimeRanges.get(i).getExpression());
        }
        if (queryExpression.hasQueryFilter()) {
            BinaryExpression.AndExpression combinedExpression = BinaryExpression.and(queryExpression.getExpression(), addTimeExpression);
            queryExpression.setExpression(combinedExpression);
        } else {
            queryExpression.setExpression(addTimeExpression);
        }
        return this.execute(queryExpression);
    }

    private QueryDataSet execute(List<Path> selectedPathList) throws IOException, NoMeasurementException {
        return this.executeMayAttachTimeFiler(selectedPathList, null);
    }

    private QueryDataSet execute(List<Path> selectedPathList, GlobalTimeExpression timeFilter) throws IOException, NoMeasurementException {
        return this.executeMayAttachTimeFiler(selectedPathList, timeFilter);
    }

    private QueryDataSet executeMayAttachTimeFiler(List<Path> selectedPathList, GlobalTimeExpression timeFilter) throws IOException, NoMeasurementException {
        ArrayList<FileSeriesReader> readersOfSelectedSeries = new ArrayList<FileSeriesReader>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Path path : selectedPathList) {
            FileSeriesReader seriesReader;
            List<ChunkMetaData> chunkMetaDataList = this.metadataQuerier.getChunkMetaDataList(path);
            if (chunkMetaDataList.isEmpty()) {
                seriesReader = new EmptyFileSeriesReader();
                dataTypes.add(this.metadataQuerier.getDataType(path.getMeasurement()));
            } else {
                seriesReader = timeFilter == null ? new FileSeriesReaderWithoutFilter(this.chunkLoader, chunkMetaDataList) : new FileSeriesReaderWithFilter(this.chunkLoader, chunkMetaDataList, timeFilter.getFilter());
                dataTypes.add(chunkMetaDataList.get(0).getTsDataType());
            }
            readersOfSelectedSeries.add(seriesReader);
        }
        return new DataSetWithoutTimeGenerator(selectedPathList, dataTypes, readersOfSelectedSeries);
    }
}

