/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LongStatistics
extends Statistics<Long> {
    private long max;
    private long min;
    private long first;
    private double sum;
    private long last;

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.max = BytesUtils.bytesToLong(maxBytes);
        this.min = BytesUtils.bytesToLong(minBytes);
    }

    @Override
    public Long getMin() {
        return this.min;
    }

    @Override
    public Long getMax() {
        return this.max;
    }

    @Override
    public Long getFirst() {
        return this.first;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public Long getLast() {
        return this.last;
    }

    @Override
    public void updateStats(long value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value, value, value);
        }
    }

    private void updateStats(long minValue, long maxValue, long firstValue, double sumValue, long lastValue) {
        if (minValue < this.min) {
            this.min = minValue;
        }
        if (maxValue > this.max) {
            this.max = maxValue;
        }
        this.sum += sumValue;
        this.last = lastValue;
    }

    @Override
    public void updateStats(long minValue, long maxValue) {
        if (minValue < this.min) {
            this.min = minValue;
        }
        if (maxValue > this.max) {
            this.max = maxValue;
        }
    }

    @Override
    protected void mergeStatisticsValue(Statistics<?> stats) {
        LongStatistics longStats = (LongStatistics)stats;
        if (this.isEmpty) {
            this.initializeStats(longStats.getMin(), longStats.getMax(), longStats.getFirst(), longStats.getSum(), longStats.getLast());
            this.isEmpty = false;
        } else {
            this.updateStats(longStats.getMin(), longStats.getMax(), longStats.getFirst(), longStats.getSum(), longStats.getLast());
        }
    }

    void initializeStats(long min, long max, long firstValue, double sum, long last) {
        this.min = min;
        this.max = max;
        this.first = firstValue;
        this.sum += sum;
        this.last = last;
    }

    @Override
    public byte[] getMaxBytes() {
        return BytesUtils.longToBytes(this.max);
    }

    @Override
    public byte[] getMinBytes() {
        return BytesUtils.longToBytes(this.min);
    }

    @Override
    public byte[] getFirstBytes() {
        return BytesUtils.longToBytes(this.first);
    }

    @Override
    public byte[] getSumBytes() {
        return BytesUtils.doubleToBytes(this.sum);
    }

    @Override
    public byte[] getLastBytes() {
        return BytesUtils.longToBytes(this.last);
    }

    @Override
    public ByteBuffer getMaxBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.max);
    }

    @Override
    public ByteBuffer getMinBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.min);
    }

    @Override
    public ByteBuffer getFirstBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.first);
    }

    @Override
    public ByteBuffer getSumBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.sum);
    }

    @Override
    public ByteBuffer getLastBytebuffer() {
        return ReadWriteIOUtils.getByteBuffer(this.last);
    }

    public String toString() {
        return "[max:" + this.max + ",min:" + this.min + ",first:" + this.first + ",sum:" + this.sum + ",last:" + this.last + "]";
    }

    @Override
    public int sizeOfDatum() {
        return 8;
    }

    @Override
    void fill(InputStream inputStream) throws IOException {
        this.min = ReadWriteIOUtils.readLong(inputStream);
        this.max = ReadWriteIOUtils.readLong(inputStream);
        this.first = ReadWriteIOUtils.readLong(inputStream);
        this.last = ReadWriteIOUtils.readLong(inputStream);
        this.sum = ReadWriteIOUtils.readDouble(inputStream);
    }

    @Override
    void fill(ByteBuffer byteBuffer) throws IOException {
        this.min = ReadWriteIOUtils.readLong(byteBuffer);
        this.max = ReadWriteIOUtils.readLong(byteBuffer);
        this.first = ReadWriteIOUtils.readLong(byteBuffer);
        this.last = ReadWriteIOUtils.readLong(byteBuffer);
        this.sum = ReadWriteIOUtils.readDouble(byteBuffer);
    }
}

