/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TsDigest {
    private Map<String, ByteBuffer> statistics;
    private int serializedSize = 4;
    private int sizeOfList;

    public static int getNullDigestSize() {
        return 4;
    }

    public static int serializeNullTo(OutputStream outputStream) throws IOException {
        return ReadWriteIOUtils.write(0, outputStream);
    }

    public static int serializeNullTo(ByteBuffer buffer) {
        return ReadWriteIOUtils.write(0, buffer);
    }

    public static TsDigest deserializeFrom(InputStream inputStream) throws IOException {
        TsDigest digest = new TsDigest();
        int size = ReadWriteIOUtils.readInt(inputStream);
        if (size > 0) {
            HashMap<String, ByteBuffer> statistics = new HashMap<String, ByteBuffer>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(inputStream);
                ByteBuffer value = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(inputStream);
                statistics.put(key, value);
            }
            digest.statistics = statistics;
        }
        return digest;
    }

    public static TsDigest deserializeFrom(ByteBuffer buffer) {
        TsDigest digest = new TsDigest();
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size > 0) {
            HashMap<String, ByteBuffer> statistics = new HashMap<String, ByteBuffer>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(buffer);
                ByteBuffer value = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(buffer);
                statistics.put(key, value);
            }
            digest.statistics = statistics;
        }
        return digest;
    }

    private void reCalculateSerializedSize() {
        this.serializedSize = 4;
        if (this.statistics != null) {
            for (Map.Entry<String, ByteBuffer> entry : this.statistics.entrySet()) {
                this.serializedSize += 4 + entry.getKey().length() + 4 + entry.getValue().remaining();
            }
            this.sizeOfList = this.statistics.size();
        } else {
            this.sizeOfList = 0;
        }
    }

    public Map<String, ByteBuffer> getStatistics() {
        if (this.statistics == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.statistics);
    }

    public void setStatistics(Map<String, ByteBuffer> statistics) {
        this.statistics = statistics;
        this.reCalculateSerializedSize();
    }

    public void addStatistics(String key, ByteBuffer value) {
        if (this.statistics == null) {
            this.statistics = new HashMap<String, ByteBuffer>();
        }
        this.statistics.put(key, value);
        this.serializedSize += 4 + key.length() + 4 + value.remaining();
        ++this.sizeOfList;
    }

    public String toString() {
        return this.statistics != null ? this.statistics.toString() : "";
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        if (this.statistics != null && this.sizeOfList != this.statistics.size() || this.statistics == null && this.sizeOfList != 0) {
            this.reCalculateSerializedSize();
        }
        int byteLen = 0;
        if (this.statistics == null || this.statistics.size() == 0) {
            byteLen += ReadWriteIOUtils.write(0, outputStream);
        } else {
            byteLen += ReadWriteIOUtils.write(this.statistics.size(), outputStream);
            for (Map.Entry<String, ByteBuffer> entry : this.statistics.entrySet()) {
                byteLen += ReadWriteIOUtils.write(entry.getKey(), outputStream);
                byteLen += ReadWriteIOUtils.write(entry.getValue(), outputStream);
            }
        }
        return byteLen;
    }

    public int serializeTo(ByteBuffer buffer) {
        if (this.statistics != null && this.sizeOfList != this.statistics.size() || this.statistics == null && this.sizeOfList != 0) {
            this.reCalculateSerializedSize();
        }
        int byteLen = 0;
        if (this.statistics == null || this.statistics.size() == 0) {
            byteLen += ReadWriteIOUtils.write(0, buffer);
        } else {
            byteLen += ReadWriteIOUtils.write(this.statistics.size(), buffer);
            for (Map.Entry<String, ByteBuffer> entry : this.statistics.entrySet()) {
                byteLen += ReadWriteIOUtils.write(entry.getKey(), buffer);
                byteLen += ReadWriteIOUtils.write(entry.getValue(), buffer);
            }
        }
        return byteLen;
    }

    public int getSerializedSize() {
        if (this.statistics == null || this.sizeOfList != this.statistics.size()) {
            this.reCalculateSerializedSize();
        }
        return this.serializedSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsDigest digest = (TsDigest)o;
        if (this.serializedSize != digest.serializedSize || this.sizeOfList != digest.sizeOfList || this.statistics.size() != digest.statistics.size()) {
            return false;
        }
        for (Map.Entry<String, ByteBuffer> entry : this.statistics.entrySet()) {
            String key = entry.getKey();
            ByteBuffer value = entry.getValue();
            if (digest.statistics.containsKey(key) && value.equals(digest.statistics.get(key))) continue;
            return false;
        }
        return true;
    }
}

