/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TsDeviceMetadata {
    private int serializedSize = 20;
    private long startTime = Long.MAX_VALUE;
    private long endTime = Long.MIN_VALUE;
    private List<ChunkGroupMetaData> chunkGroupMetadataList = new ArrayList<ChunkGroupMetaData>();

    public static TsDeviceMetadata deserializeFrom(InputStream inputStream) throws IOException {
        TsDeviceMetadata deviceMetadata = new TsDeviceMetadata();
        deviceMetadata.startTime = ReadWriteIOUtils.readLong(inputStream);
        deviceMetadata.endTime = ReadWriteIOUtils.readLong(inputStream);
        int size = ReadWriteIOUtils.readInt(inputStream);
        if (size > 0) {
            ArrayList<ChunkGroupMetaData> chunkGroupMetaDataList = new ArrayList<ChunkGroupMetaData>();
            for (int i = 0; i < size; ++i) {
                chunkGroupMetaDataList.add(ChunkGroupMetaData.deserializeFrom(inputStream));
            }
            deviceMetadata.chunkGroupMetadataList = chunkGroupMetaDataList;
        }
        deviceMetadata.reCalculateSerializedSize();
        return deviceMetadata;
    }

    public static TsDeviceMetadata deserializeFrom(ByteBuffer buffer) throws IOException {
        TsDeviceMetadata deviceMetadata = new TsDeviceMetadata();
        deviceMetadata.startTime = ReadWriteIOUtils.readLong(buffer);
        deviceMetadata.endTime = ReadWriteIOUtils.readLong(buffer);
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size > 0) {
            ArrayList<ChunkGroupMetaData> chunkGroupMetaDataList = new ArrayList<ChunkGroupMetaData>();
            for (int i = 0; i < size; ++i) {
                chunkGroupMetaDataList.add(ChunkGroupMetaData.deserializeFrom(buffer));
            }
            deviceMetadata.chunkGroupMetadataList = chunkGroupMetaDataList;
        }
        deviceMetadata.reCalculateSerializedSize();
        return deviceMetadata;
    }

    public int getSerializedSize() {
        return this.serializedSize;
    }

    private void reCalculateSerializedSize() {
        this.serializedSize = 20;
        for (ChunkGroupMetaData meta : this.chunkGroupMetadataList) {
            this.serializedSize += meta.getSerializedSize();
        }
    }

    public void setChunkGroupMetadataList(List<ChunkGroupMetaData> chunkGroupMetadataList) {
        this.chunkGroupMetadataList = chunkGroupMetadataList;
        this.reCalculateSerializedSize();
    }

    public void addChunkGroupMetaData(ChunkGroupMetaData chunkGroup) {
        this.chunkGroupMetadataList.add(chunkGroup);
        this.serializedSize += chunkGroup.getSerializedSize();
        for (ChunkMetaData chunkMetaData : chunkGroup.getChunkMetaDataList()) {
            this.startTime = Long.min(this.startTime, chunkMetaData.getStartTime());
            this.endTime = Long.max(this.endTime, chunkMetaData.getEndTime());
        }
    }

    public List<ChunkGroupMetaData> getChunkGroupMetaDataList() {
        return Collections.unmodifiableList(this.chunkGroupMetadataList);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.startTime, outputStream);
        byteLen += ReadWriteIOUtils.write(this.endTime, outputStream);
        if (this.chunkGroupMetadataList == null) {
            byteLen += ReadWriteIOUtils.write(0, outputStream);
        } else {
            byteLen += ReadWriteIOUtils.write(this.chunkGroupMetadataList.size(), outputStream);
            for (ChunkGroupMetaData chunkGroupMetaData : this.chunkGroupMetadataList) {
                byteLen += chunkGroupMetaData.serializeTo(outputStream);
            }
        }
        return byteLen;
    }

    public int serializeTo(ByteBuffer buffer) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.startTime, buffer);
        byteLen += ReadWriteIOUtils.write(this.endTime, buffer);
        if (this.chunkGroupMetadataList == null) {
            byteLen += ReadWriteIOUtils.write(0, buffer);
        } else {
            byteLen += ReadWriteIOUtils.write(this.chunkGroupMetadataList.size(), buffer);
            for (ChunkGroupMetaData chunkGroupMetaData : this.chunkGroupMetadataList) {
                byteLen += chunkGroupMetaData.serializeTo(buffer);
            }
        }
        return byteLen;
    }

    public String toString() {
        return "TsDeviceMetadata{serializedSize=" + this.serializedSize + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", chunkGroupMetadataList=" + this.chunkGroupMetadataList + '}';
    }
}

