/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.file.metadata.TsDigest;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkMetaData {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkMetaData.class);
    private String measurementUid;
    private long offsetOfChunkHeader;
    private long numOfPoints;
    private long startTime;
    private long endTime;
    private TSDataType tsDataType;
    private long version;
    private long deletedAt = -1L;
    private TsDigest valuesStatistics;

    private ChunkMetaData() {
    }

    public ChunkMetaData(String measurementUid, TSDataType tsDataType, long fileOffset, long startTime, long endTime) {
        this.measurementUid = measurementUid;
        this.tsDataType = tsDataType;
        this.offsetOfChunkHeader = fileOffset;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public static ChunkMetaData deserializeFrom(InputStream inputStream) throws IOException {
        ChunkMetaData chunkMetaData = new ChunkMetaData();
        chunkMetaData.measurementUid = ReadWriteIOUtils.readString(inputStream);
        chunkMetaData.offsetOfChunkHeader = ReadWriteIOUtils.readLong(inputStream);
        chunkMetaData.numOfPoints = ReadWriteIOUtils.readLong(inputStream);
        chunkMetaData.startTime = ReadWriteIOUtils.readLong(inputStream);
        chunkMetaData.endTime = ReadWriteIOUtils.readLong(inputStream);
        chunkMetaData.tsDataType = ReadWriteIOUtils.readDataType(inputStream);
        chunkMetaData.valuesStatistics = TsDigest.deserializeFrom(inputStream);
        return chunkMetaData;
    }

    public static ChunkMetaData deserializeFrom(ByteBuffer buffer) {
        ChunkMetaData chunkMetaData = new ChunkMetaData();
        chunkMetaData.measurementUid = ReadWriteIOUtils.readString(buffer);
        chunkMetaData.offsetOfChunkHeader = ReadWriteIOUtils.readLong(buffer);
        chunkMetaData.numOfPoints = ReadWriteIOUtils.readLong(buffer);
        chunkMetaData.startTime = ReadWriteIOUtils.readLong(buffer);
        chunkMetaData.endTime = ReadWriteIOUtils.readLong(buffer);
        chunkMetaData.tsDataType = ReadWriteIOUtils.readDataType(buffer);
        chunkMetaData.valuesStatistics = TsDigest.deserializeFrom(buffer);
        return chunkMetaData;
    }

    public int getSerializedSize() {
        int serializedSize = 36 + TSDataType.getSerializedSize() + (this.valuesStatistics == null ? TsDigest.getNullDigestSize() : this.valuesStatistics.getSerializedSize());
        try {
            serializedSize += this.measurementUid.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            serializedSize += this.measurementUid.getBytes().length;
            LOG.error("{} encoding is not supported", (Object)"UTF-8");
        }
        return serializedSize;
    }

    public String toString() {
        return String.format("numPoints %d", this.numOfPoints);
    }

    public long getNumOfPoints() {
        return this.numOfPoints;
    }

    public void setNumOfPoints(long numRows) {
        this.numOfPoints = numRows;
    }

    public long getOffsetOfChunkHeader() {
        return this.offsetOfChunkHeader;
    }

    public String getMeasurementUid() {
        return this.measurementUid;
    }

    public TsDigest getDigest() {
        return this.valuesStatistics;
    }

    public void setDigest(TsDigest digest) {
        this.valuesStatistics = digest;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public TSDataType getTsDataType() {
        return this.tsDataType;
    }

    public void setTsDataType(TSDataType tsDataType) {
        this.tsDataType = tsDataType;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.measurementUid, outputStream);
        byteLen += ReadWriteIOUtils.write(this.offsetOfChunkHeader, outputStream);
        byteLen += ReadWriteIOUtils.write(this.numOfPoints, outputStream);
        byteLen += ReadWriteIOUtils.write(this.startTime, outputStream);
        byteLen += ReadWriteIOUtils.write(this.endTime, outputStream);
        byteLen += ReadWriteIOUtils.write(this.tsDataType, outputStream);
        byteLen = this.valuesStatistics == null ? (byteLen += TsDigest.serializeNullTo(outputStream)) : (byteLen += this.valuesStatistics.serializeTo(outputStream));
        return byteLen;
    }

    public int serializeTo(ByteBuffer buffer) {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.measurementUid, buffer);
        byteLen += ReadWriteIOUtils.write(this.offsetOfChunkHeader, buffer);
        byteLen += ReadWriteIOUtils.write(this.numOfPoints, buffer);
        byteLen += ReadWriteIOUtils.write(this.startTime, buffer);
        byteLen += ReadWriteIOUtils.write(this.endTime, buffer);
        byteLen += ReadWriteIOUtils.write(this.tsDataType, buffer);
        byteLen = this.valuesStatistics == null ? (byteLen += TsDigest.serializeNullTo(buffer)) : (byteLen += this.valuesStatistics.serializeTo(buffer));
        return byteLen;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getDeletedAt() {
        return this.deletedAt;
    }

    public void setDeletedAt(long deletedAt) {
        this.deletedAt = deletedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkMetaData that = (ChunkMetaData)o;
        return this.offsetOfChunkHeader == that.offsetOfChunkHeader && this.numOfPoints == that.numOfPoints && this.startTime == that.startTime && this.endTime == that.endTime && this.version == that.version && this.deletedAt == that.deletedAt && Objects.equals(this.measurementUid, that.measurementUid) && this.tsDataType == that.tsDataType && Objects.equals(this.valuesStatistics, that.valuesStatistics);
    }
}

