/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.footer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ChunkGroupFooter {
    private static final byte MARKER = 0;
    private String deviceID;
    private long dataSize;
    private int numberOfChunks;
    private int serializedSize;

    public ChunkGroupFooter(String deviceID, long dataSize, int numberOfChunks) throws UnsupportedEncodingException {
        this.deviceID = deviceID;
        this.dataSize = dataSize;
        this.numberOfChunks = numberOfChunks;
        this.serializedSize = 5 + deviceID.getBytes("UTF-8").length + 8 + 4;
    }

    public static int getSerializedSize(String deviceID) {
        return 5 + ChunkGroupFooter.getSerializedSize(deviceID.length());
    }

    private static int getSerializedSize(int deviceIdLength) {
        return deviceIdLength + 8 + 4;
    }

    public static ChunkGroupFooter deserializeFrom(InputStream inputStream, boolean markerRead) throws IOException {
        byte marker;
        if (!markerRead && (marker = (byte)inputStream.read()) != 0) {
            MetaMarker.handleUnexpectedMarker(marker);
        }
        String deviceID = ReadWriteIOUtils.readString(inputStream);
        long dataSize = ReadWriteIOUtils.readLong(inputStream);
        int numOfChunks = ReadWriteIOUtils.readInt(inputStream);
        return new ChunkGroupFooter(deviceID, dataSize, numOfChunks);
    }

    public static ChunkGroupFooter deserializeFrom(TsFileInput input, long offset, boolean markerRead) throws IOException {
        long offsetVar = offset;
        if (!markerRead) {
            ++offsetVar;
        }
        ByteBuffer buffer = ByteBuffer.allocate(4);
        input.read(buffer, offsetVar);
        buffer.flip();
        int size = buffer.getInt();
        buffer = ByteBuffer.allocate(ChunkGroupFooter.getSerializedSize(size));
        ReadWriteIOUtils.readAsPossible(input, offsetVar += 4L, buffer);
        buffer.flip();
        String deviceID = ReadWriteIOUtils.readStringWithoutLength(buffer, size);
        long dataSize = ReadWriteIOUtils.readLong(buffer);
        int numOfChunks = ReadWriteIOUtils.readInt(buffer);
        return new ChunkGroupFooter(deviceID, dataSize, numOfChunks);
    }

    public int getSerializedSize() {
        return this.serializedSize;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long dataSize) {
        this.dataSize = dataSize;
    }

    public int getNumberOfChunks() {
        return this.numberOfChunks;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int length = 0;
        length += ReadWriteIOUtils.write((byte)0, outputStream);
        length += ReadWriteIOUtils.write(this.deviceID, outputStream);
        length += ReadWriteIOUtils.write(this.dataSize, outputStream);
        return length += ReadWriteIOUtils.write(this.numberOfChunks, outputStream);
    }

    public String toString() {
        return "CHUNK_GROUP_FOOTER{deviceID='" + this.deviceID + '\'' + ", dataSize=" + this.dataSize + ", numberOfChunks=" + this.numberOfChunks + ", serializedSize=" + this.serializedSize + '}';
    }
}

