/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.common.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.utils.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSFileDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(TSFileDescriptor.class);
    private TSFileConfig conf = new TSFileConfig();

    private TSFileDescriptor() {
        this.loadProps();
    }

    public static final TSFileDescriptor getInstance() {
        return TsfileDescriptorHolder.INSTANCE;
    }

    public TSFileConfig getConfig() {
        return this.conf;
    }

    private void multiplicityWarning(String resource, ClassLoader classLoader) {
        try {
            Set<URL> urlSet = Loader.getResources(resource, classLoader);
            if (urlSet != null && urlSet.size() > 1) {
                logger.warn("Resource [{}] occurs multiple times on the classpath", (Object)resource);
                for (URL url : urlSet) {
                    logger.warn("Resource [{}] occurs at [{}]", (Object)resource, (Object)url);
                }
            }
        }
        catch (IOException e) {
            logger.error("Failed to get url list for {}", (Object)resource);
        }
    }

    private static URL getResource(String filename, ClassLoader classLoader) {
        return Loader.getResource(filename, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        FileInputStream inputStream;
        String url = System.getProperty("TSFILE_CONF", null);
        if (url == null) {
            url = System.getProperty("TSFILE_HOME", null);
            if (url != null) {
                url = url + File.separator + "conf" + File.separator + "tsfile-format.properties";
            } else {
                ClassLoader classLoader = Loader.getClassLoaderOfObject(this);
                URL u = TSFileDescriptor.getResource("tsfile-format.properties", classLoader);
                if (u == null) {
                    logger.warn("Failed to find config file {} at classpath, use default configuration", (Object)"tsfile-format.properties");
                    return;
                }
                this.multiplicityWarning("tsfile-format.properties", classLoader);
                url = u.getFile();
            }
        }
        try {
            inputStream = new FileInputStream(new File(url));
        }
        catch (FileNotFoundException e) {
            logger.warn("Fail to find config file {}", (Object)url);
            return;
        }
        logger.info("Start to read config file {}", (Object)url);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            TSFileConfig.groupSizeInByte = Integer.parseInt(properties.getProperty("group_size_in_byte", Integer.toString(TSFileConfig.groupSizeInByte)));
            TSFileConfig.pageSizeInByte = Integer.parseInt(properties.getProperty("page_size_in_byte", Integer.toString(TSFileConfig.pageSizeInByte)));
            if (TSFileConfig.pageSizeInByte > TSFileConfig.groupSizeInByte) {
                logger.warn("page_size is greater than group size, will set it as the same with group size");
                TSFileConfig.pageSizeInByte = TSFileConfig.groupSizeInByte;
            }
            TSFileConfig.maxNumberOfPointsInPage = Integer.parseInt(properties.getProperty("max_number_of_points_in_page", Integer.toString(TSFileConfig.maxNumberOfPointsInPage)));
            TSFileConfig.timeSeriesDataType = properties.getProperty("time_series_data_type", TSFileConfig.timeSeriesDataType);
            TSFileConfig.maxStringLength = Integer.parseInt(properties.getProperty("max_string_length", Integer.toString(TSFileConfig.maxStringLength)));
            TSFileConfig.floatPrecision = Integer.parseInt(properties.getProperty("float_precision", Integer.toString(TSFileConfig.floatPrecision)));
            TSFileConfig.timeEncoder = properties.getProperty("time_encoder", TSFileConfig.timeEncoder);
            TSFileConfig.valueEncoder = properties.getProperty("value_encoder", TSFileConfig.valueEncoder);
            TSFileConfig.compressor = properties.getProperty("compressor", TSFileConfig.compressor);
        }
        catch (IOException e) {
            logger.warn("Cannot load config file, use default configuration", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Loading settings {} failed", (Object)url, (Object)e);
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                logger.error("Failed to close stream for loading config", (Throwable)e);
            }
        }
    }

    private static class TsfileDescriptorHolder {
        private static final TSFileDescriptor INSTANCE = new TSFileDescriptor();

        private TsfileDescriptorHolder() {
            throw new IllegalAccessError("Utility class");
        }
    }
}

