/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.sync.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncLogReader {
    private static final Logger logger = LoggerFactory.getLogger(SyncLogReader.class);
    private final Map<String, PipeSink> pipeSinks = new ConcurrentHashMap<String, PipeSink>();
    private final Map<String, Map<Long, PipeInfo>> pipes = new ConcurrentHashMap<String, Map<Long, PipeInfo>>();
    private PipeInfo runningPipe;
    private final File dir;
    private final String fileName;

    public SyncLogReader(File dir) {
        this.dir = dir;
        this.fileName = "syncService.log";
    }

    public SyncLogReader(File dir, String fileName) {
        this.dir = dir;
        this.fileName = fileName;
    }

    public void recover() throws IOException {
        logger.info("Start to recover all sync state for sync.");
        File serviceLogFile = new File(this.dir, this.fileName);
        if (!serviceLogFile.exists()) {
            logger.warn("Sync service log file not found");
        } else {
            try (FileInputStream inputStream = new FileInputStream(serviceLogFile);){
                this.recoverPipe(inputStream);
            }
        }
    }

    public Map<String, PipeSink> getAllPipeSinks() {
        return this.pipeSinks;
    }

    public Map<String, Map<Long, PipeInfo>> getAllPipeInfos() {
        return this.pipes;
    }

    public PipeInfo getRunningPipeInfo() {
        return this.runningPipe;
    }

    private void recoverPipe(InputStream inputStream) throws IOException {
        byte nextByte;
        block8: while ((nextByte = ReadWriteIOUtils.readByte((InputStream)inputStream)) != -1) {
            SyncOperation operationType = SyncOperation.values()[nextByte];
            switch (operationType) {
                case CREATE_PIPESINK: {
                    PipeSink pipeSink = PipeSink.deserializePipeSink(inputStream);
                    this.pipeSinks.put(pipeSink.getPipeSinkName(), pipeSink);
                    continue block8;
                }
                case DROP_PIPESINK: {
                    this.pipeSinks.remove(ReadWriteIOUtils.readString((InputStream)inputStream));
                    continue block8;
                }
                case CREATE_PIPE: {
                    this.runningPipe = PipeInfo.deserializePipeInfo(inputStream);
                    this.pipes.computeIfAbsent(this.runningPipe.getPipeName(), i -> new ConcurrentHashMap()).computeIfAbsent(this.runningPipe.getCreateTime(), i -> this.runningPipe);
                    continue block8;
                }
                case STOP_PIPE: {
                    ReadWriteIOUtils.readString((InputStream)inputStream);
                    this.runningPipe.setStatus(PipeStatus.STOP);
                    continue block8;
                }
                case START_PIPE: {
                    ReadWriteIOUtils.readString((InputStream)inputStream);
                    this.runningPipe.setStatus(PipeStatus.RUNNING);
                    continue block8;
                }
                case DROP_PIPE: {
                    ReadWriteIOUtils.readString((InputStream)inputStream);
                    this.runningPipe.setStatus(PipeStatus.DROP);
                    continue block8;
                }
            }
            throw new UnsupportedOperationException(String.format("Can not recognize SyncOperation %s.", operationType.name()));
        }
    }
}

