/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.timerangeiterator;

import org.apache.iotdb.db.utils.timerangeiterator.AggrWindowIterator;
import org.apache.iotdb.db.utils.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.utils.timerangeiterator.PreAggrWindowIterator;
import org.apache.iotdb.db.utils.timerangeiterator.PreAggrWindowWithNaturalMonthIterator;

public class TimeRangeIteratorFactory {
    private TimeRangeIteratorFactory() {
    }

    public static ITimeRangeIterator getTimeRangeIterator(long startTime, long endTime, long interval, long slidingStep, boolean isAscending, boolean isIntervalByMonth, boolean isSlidingStepByMonth, boolean isPreAggr) {
        long tmpSlidingStep;
        long tmpInterval = isIntervalByMonth ? interval * 2592000000L : interval;
        long l = tmpSlidingStep = isSlidingStepByMonth ? slidingStep * 2592000000L : slidingStep;
        if (isPreAggr && tmpInterval > tmpSlidingStep) {
            if (!isIntervalByMonth && !isSlidingStepByMonth) {
                return new PreAggrWindowIterator(startTime, endTime, interval, slidingStep, isAscending);
            }
            return new PreAggrWindowWithNaturalMonthIterator(startTime, endTime, interval, slidingStep, isAscending, isSlidingStepByMonth, isIntervalByMonth);
        }
        return new AggrWindowIterator(startTime, endTime, interval, slidingStep, isAscending, isSlidingStepByMonth, isIntervalByMonth);
    }
}

