/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.utils.Pair;

public class CreatePipeSinkPlan
extends PhysicalPlan {
    private String pipeSinkName;
    private String pipeSinkType;
    private List<Pair<String, String>> pipeSinkAttributes;

    public CreatePipeSinkPlan(String pipeSinkName, String pipeSinkType) {
        super(Operator.OperatorType.CREATE_PIPESINK);
        this.pipeSinkName = pipeSinkName;
        this.pipeSinkType = pipeSinkType;
        this.pipeSinkAttributes = new ArrayList<Pair<String, String>>();
    }

    public void addPipeSinkAttribute(String attr, String value) {
        this.pipeSinkAttributes.add((Pair<String, String>)new Pair((Object)attr, (Object)value));
    }

    public String getPipeSinkName() {
        return this.pipeSinkName;
    }

    public String getPipeSinkType() {
        return this.pipeSinkType;
    }

    public List<Pair<String, String>> getPipeSinkAttributes() {
        return this.pipeSinkAttributes;
    }

    @Override
    public List<? extends PartialPath> getPaths() {
        return Collections.emptyList();
    }

    public static CreatePipeSinkPlan parseString(String parsedString) throws IOException {
        String[] attributes = parsedString.split(",");
        if (attributes.length < 3) {
            throw new IOException("Parsing CreatePipeSinkPlan error. Attributes is less than expected.");
        }
        CreatePipeSinkPlan plan = new CreatePipeSinkPlan(attributes[0], attributes[1]);
        int size = Integer.parseInt(attributes[2]) << 1;
        if (attributes.length != size + 3) {
            throw new IOException("Parsing CreatePipeSinkPlan error. Attributes number is wrong.");
        }
        for (int i = 0; i < size; i += 2) {
            plan.addPipeSinkAttribute(attributes[i + 3], attributes[i + 4]);
        }
        return plan;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.pipeSinkName).append(",");
        builder.append(this.pipeSinkType).append(",");
        builder.append(this.pipeSinkAttributes.size()).append(",");
        for (int i = 0; i < this.pipeSinkAttributes.size(); ++i) {
            builder.append((String)this.pipeSinkAttributes.get((int)i).left).append(",");
            builder.append((String)this.pipeSinkAttributes.get((int)i).right).append(",");
        }
        return builder.toString();
    }
}

