/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;

public class SelectIntoPlan
extends PhysicalPlan {
    private QueryPlan queryPlan;
    private PartialPath fromPath;
    private List<PartialPath> intoPaths;
    private boolean isIntoPathsAligned;

    public SelectIntoPlan() {
        super(Operator.OperatorType.SELECT_INTO);
    }

    public SelectIntoPlan(QueryPlan queryPlan, PartialPath fromPath, List<PartialPath> intoPaths, boolean isIntoPathsAligned) {
        super(Operator.OperatorType.SELECT_INTO);
        this.queryPlan = queryPlan;
        this.fromPath = fromPath;
        this.intoPaths = intoPaths;
        this.isIntoPathsAligned = isIntoPathsAligned;
    }

    @Override
    public boolean isSelectInto() {
        return true;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        outputStream.writeByte((byte)PhysicalPlan.PhysicalPlanType.SELECT_INTO.ordinal());
        this.queryPlan.serialize(outputStream);
        this.putString(outputStream, this.fromPath.getFullPath());
        outputStream.writeInt(this.intoPaths.size());
        for (PartialPath intoPath : this.intoPaths) {
            this.putString(outputStream, intoPath.getFullPath());
        }
        outputStream.writeByte(this.isIntoPathsAligned ? 1 : 0);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.SELECT_INTO.ordinal());
        this.queryPlan.serialize(buffer);
        this.putString(buffer, this.fromPath.getFullPath());
        buffer.putInt(this.intoPaths.size());
        for (PartialPath intoPath : this.intoPaths) {
            this.putString(buffer, intoPath.getFullPath());
        }
        buffer.put((byte)(this.isIntoPathsAligned ? 1 : 0));
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException, IOException {
        this.queryPlan = (QueryPlan)PhysicalPlan.Factory.create(buffer);
        this.fromPath = new PartialPath(this.readString(buffer));
        int intoPathsSize = buffer.getInt();
        this.intoPaths = new ArrayList<PartialPath>(intoPathsSize);
        for (int i = 0; i < intoPathsSize; ++i) {
            this.intoPaths.add(new PartialPath(this.readString(buffer)));
        }
        this.isIntoPathsAligned = buffer.get() == 1;
    }

    public List<MeasurementPath> getPaths() {
        return this.queryPlan.getPaths();
    }

    public QueryPlan getQueryPlan() {
        return this.queryPlan;
    }

    public PartialPath getFromPath() {
        return this.fromPath;
    }

    public List<PartialPath> getIntoPaths() {
        return this.intoPaths;
    }

    public boolean isIntoPathsAligned() {
        return this.isIntoPathsAligned;
    }
}

