/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class InsertPlan
extends PhysicalPlan {
    protected PartialPath devicePath;
    protected boolean isAligned;
    protected String[] measurements;
    protected TSDataType[] dataTypes;
    protected IMeasurementMNode[] measurementMNodes;
    protected IDeviceID deviceID;
    List<String> failedMeasurements;
    private List<Exception> failedExceptions;
    List<Integer> failedIndices;

    public InsertPlan(Operator.OperatorType operatorType) {
        super(operatorType);
        this.canBeSplit = false;
    }

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(PartialPath devicePath) {
        this.devicePath = devicePath;
    }

    public String[] getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(String[] measurements) {
        this.measurements = measurements;
    }

    public boolean hasValidMeasurements() {
        for (String o : this.measurements) {
            if (o == null) continue;
            return true;
        }
        return false;
    }

    public TSDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(TSDataType[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    public IMeasurementMNode[] getMeasurementMNodes() {
        return this.measurementMNodes;
    }

    public void setMeasurementMNodes(IMeasurementMNode[] mNodes) {
        this.measurementMNodes = mNodes;
    }

    public List<String> getFailedMeasurements() {
        return this.failedMeasurements;
    }

    public List<Exception> getFailedExceptions() {
        return this.failedExceptions;
    }

    public int getFailedMeasurementNumber() {
        return this.failedMeasurements == null ? 0 : this.failedMeasurements.size();
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public void setAligned(boolean aligned) {
        this.isAligned = aligned;
    }

    public abstract long getMinTime();

    public abstract Object getFirstValueOfIndex(int var1);

    public void markFailedMeasurementInsertion(int index, Exception e) {
        if (this.measurements[index] == null) {
            return;
        }
        if (this.failedMeasurements == null) {
            this.failedMeasurements = new ArrayList<String>();
            this.failedExceptions = new ArrayList<Exception>();
            this.failedIndices = new ArrayList<Integer>();
        }
        this.failedMeasurements.add(this.measurements[index]);
        this.failedExceptions.add(e);
        this.failedIndices.add(index);
        this.measurements[index] = null;
    }

    public InsertPlan getPlanFromFailed() {
        int i;
        Object[] temp;
        if (this.failedMeasurements == null) {
            return null;
        }
        this.measurements = this.failedMeasurements.toArray(new String[0]);
        this.failedMeasurements = null;
        if (this.dataTypes != null) {
            temp = (TSDataType[])this.dataTypes.clone();
            this.dataTypes = new TSDataType[this.failedIndices.size()];
            for (i = 0; i < this.failedIndices.size(); ++i) {
                this.dataTypes[i] = temp[this.failedIndices.get(i)];
            }
        }
        if (this.measurementMNodes != null) {
            temp = (IMeasurementMNode[])this.measurementMNodes.clone();
            this.measurementMNodes = new IMeasurementMNode[this.failedIndices.size()];
            for (i = 0; i < this.failedIndices.size(); ++i) {
                this.measurementMNodes[i] = temp[this.failedIndices.get(i)];
            }
        }
        this.failedIndices = null;
        this.failedExceptions = null;
        return this;
    }

    public void recoverFromFailure() {
        if (this.failedMeasurements == null) {
            return;
        }
        for (int i = 0; i < this.failedMeasurements.size(); ++i) {
            int index = this.failedIndices.get(i);
            this.measurements[index] = this.failedMeasurements.get(i);
        }
        this.failedIndices = null;
        this.failedExceptions = null;
        this.failedMeasurements = null;
    }

    @Override
    public void checkIntegrity() throws QueryProcessException {
        if (this.devicePath == null) {
            throw new QueryProcessException("DeviceId is null");
        }
        if (this.measurements == null) {
            throw new QueryProcessException("Measurements are null");
        }
        HashSet<String> deduplicatedMeasurements = new HashSet<String>();
        for (String measurement : this.measurements) {
            if (measurement == null || measurement.isEmpty()) {
                throw new QueryProcessException("Measurement contains null or empty string: " + Arrays.toString(this.measurements));
            }
            if (deduplicatedMeasurements.contains(measurement)) {
                throw new QueryProcessException("Insertion contains duplicated measurement: " + measurement);
            }
            deduplicatedMeasurements.add(measurement);
        }
    }

    public IDeviceID getDeviceID() {
        return this.deviceID;
    }

    public void setDeviceID(IDeviceID deviceID) {
        this.deviceID = deviceID;
    }
}

