/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunction;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.handler.AbstractQueryHandler;
import org.apache.iotdb.db.protocol.influxdb.meta.NewInfluxDBMetaManager;
import org.apache.iotdb.db.protocol.influxdb.util.QueryResultUtils;
import org.apache.iotdb.db.protocol.influxdb.util.StringUtils;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.db.service.thrift.impl.NewInfluxDBServiceImpl;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.influxdb.InfluxDBException;
import org.influxdb.dto.QueryResult;

public class NewQueryHandler
extends AbstractQueryHandler {
    public static TSExecuteStatementResp executeStatement(String sql, long sessionId) {
        TSExecuteStatementReq tsExecuteStatementReq = new TSExecuteStatementReq();
        tsExecuteStatementReq.setStatement(sql);
        tsExecuteStatementReq.setSessionId(sessionId);
        tsExecuteStatementReq.setStatementId(NewInfluxDBServiceImpl.getClientRPCService().requestStatementId(sessionId));
        tsExecuteStatementReq.setFetchSize(5000);
        TSExecuteStatementResp executeStatementResp = NewInfluxDBServiceImpl.getClientRPCService().executeStatement(tsExecuteStatementReq);
        TSStatus tsStatus = executeStatementResp.getStatus();
        if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new InfluxDBException(tsStatus.getMessage());
        }
        return executeStatementResp;
    }

    @Override
    public Map<String, Integer> getFieldOrders(String database, String measurement, ServiceProvider serviceProvider, long sessionID) {
        HashMap<String, Integer> fieldOrders = new HashMap<String, Integer>();
        String showTimeseriesSql = "show timeseries root." + database + '.' + measurement + ".**";
        TSExecuteStatementResp executeStatementResp = NewQueryHandler.executeStatement(showTimeseriesSql, sessionID);
        List<String> paths = QueryResultUtils.getFullPaths(executeStatementResp);
        Map<String, Integer> tagOrders = NewInfluxDBMetaManager.getTagOrders(database, measurement);
        int tagOrderNums = tagOrders.size();
        int fieldNums = 0;
        for (String path : paths) {
            String filed = StringUtils.getFieldByPath(path);
            if (fieldOrders.containsKey(filed)) continue;
            fieldOrders.put(filed, tagOrderNums + fieldNums + 1);
            ++fieldNums;
        }
        return fieldOrders;
    }

    @Override
    public InfluxFunctionValue updateByIoTDBFunc(InfluxFunction function, ServiceProvider serviceProvider, String path, long sessionid) {
        switch (function.getFunctionName()) {
            case "count": {
                String functionSql = StringUtils.generateFunctionSql(function.getFunctionName(), function.getParmaName(), path);
                TSExecuteStatementResp tsExecuteStatementResp = NewQueryHandler.executeStatement(functionSql, sessionid);
                List<InfluxFunctionValue> list = QueryResultUtils.getInfluxFunctionValues(tsExecuteStatementResp);
                for (InfluxFunctionValue influxFunctionValue : list) {
                    function.updateValueIoTDBFunc(influxFunctionValue);
                }
                break;
            }
            case "mean": {
                String functionSqlCount = StringUtils.generateFunctionSql("count", function.getParmaName(), path);
                TSExecuteStatementResp tsExecuteStatementResp = NewQueryHandler.executeStatement(functionSqlCount, sessionid);
                List<InfluxFunctionValue> list = QueryResultUtils.getInfluxFunctionValues(tsExecuteStatementResp);
                for (InfluxFunctionValue influxFunctionValue : list) {
                    function.updateValueIoTDBFunc(influxFunctionValue);
                }
                String functionSqlSum = StringUtils.generateFunctionSql("sum", function.getParmaName(), path);
                tsExecuteStatementResp = NewQueryHandler.executeStatement(functionSqlSum, sessionid);
                list = QueryResultUtils.getInfluxFunctionValues(tsExecuteStatementResp);
                for (InfluxFunctionValue influxFunctionValue : list) {
                    function.updateValueIoTDBFunc(null, influxFunctionValue);
                }
                break;
            }
            case "sum": {
                String functionSql = StringUtils.generateFunctionSql("sum", function.getParmaName(), path);
                TSExecuteStatementResp tsExecuteStatementResp = NewQueryHandler.executeStatement(functionSql, sessionid);
                List<InfluxFunctionValue> list = QueryResultUtils.getInfluxFunctionValues(tsExecuteStatementResp);
                for (InfluxFunctionValue influxFunctionValue : list) {
                    function.updateValueIoTDBFunc(influxFunctionValue);
                }
                break;
            }
            case "first": 
            case "last": {
                String functionName;
                String functionSql;
                if (function.getFunctionName().equals("first")) {
                    functionSql = StringUtils.generateFunctionSql("first_value", function.getParmaName(), path);
                    functionName = "first_value";
                } else {
                    functionSql = StringUtils.generateFunctionSql("last_value", function.getParmaName(), path);
                    functionName = "last_value";
                }
                TSExecuteStatementResp tsExecuteStatementResp = NewQueryHandler.executeStatement(functionSql, sessionid);
                Map<String, Object> map = QueryResultUtils.getColumnNameAndValue(tsExecuteStatementResp);
                for (String colume : map.keySet()) {
                    Object o = map.get(colume);
                    String fullPath = colume.substring(functionName.length() + 1, colume.length() - 1);
                    String devicePath = StringUtils.getDeviceByPath(fullPath);
                    String specificSql = String.format("select %s from %s where %s=%s", function.getParmaName(), devicePath, fullPath, o);
                    TSExecuteStatementResp resp = NewQueryHandler.executeStatement(specificSql, sessionid);
                    List<InfluxFunctionValue> list = QueryResultUtils.getInfluxFunctionValues(resp);
                    for (InfluxFunctionValue influxFunctionValue : list) {
                        function.updateValueIoTDBFunc(influxFunctionValue);
                    }
                }
                break;
            }
            case "max": 
            case "min": {
                String functionSql = function.getFunctionName().equals("max") ? StringUtils.generateFunctionSql("max_value", function.getParmaName(), path) : StringUtils.generateFunctionSql("min_value", function.getParmaName(), path);
                TSExecuteStatementResp tsExecuteStatementResp = NewQueryHandler.executeStatement(functionSql, sessionid);
                List<InfluxFunctionValue> list = QueryResultUtils.getInfluxFunctionValues(tsExecuteStatementResp);
                for (InfluxFunctionValue influxFunctionValue : list) {
                    function.updateValueIoTDBFunc(influxFunctionValue);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + function.getFunctionName());
            }
        }
        return function.calculateByIoTDBFunc();
    }

    @Override
    public QueryResult queryByConditions(String querySql, String database, String measurement, ServiceProvider serviceProvider, Map<String, Integer> fieldOrders, long sessionId) {
        TSExecuteStatementResp executeStatementResp = NewQueryHandler.executeStatement(querySql, sessionId);
        return QueryResultUtils.iotdbResultConvertInfluxResult(executeStatementResp, database, measurement, fieldOrders);
    }
}

