/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.function.selector;

import java.util.List;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.function.selector.InfluxSelector;

public class InfluxMaxFunction
extends InfluxSelector {
    private Double doubleValue = Double.MIN_VALUE;
    private String stringValue = null;
    private boolean isNumber = false;
    private boolean isString = false;
    private Double maxValue = null;

    public InfluxMaxFunction(List<Expression> expressionList) {
        super(expressionList);
    }

    @Override
    public InfluxFunctionValue calculateBruteForce() {
        if (!this.isString && !this.isNumber) {
            return new InfluxFunctionValue(null, null);
        }
        if (this.isString) {
            return new InfluxFunctionValue(this.stringValue, this.getTimestamp());
        }
        return new InfluxFunctionValue(this.doubleValue, this.getTimestamp());
    }

    @Override
    public InfluxFunctionValue calculateByIoTDBFunc() {
        return new InfluxFunctionValue(this.maxValue, this.maxValue == null ? null : Long.valueOf(0L));
    }

    @Override
    public void updateValueIoTDBFunc(InfluxFunctionValue ... functionValues) {
        if (functionValues[0].getValue() instanceof Number) {
            double tmpValue = ((Number)functionValues[0].getValue()).doubleValue();
            if (this.maxValue == null) {
                this.maxValue = tmpValue;
            } else if (tmpValue > this.maxValue) {
                this.maxValue = tmpValue;
            }
        }
    }

    @Override
    public String getFunctionName() {
        return "max";
    }

    @Override
    public void updateValueAndRelateValues(InfluxFunctionValue functionValue, List<Object> relatedValues) {
        Object value = functionValue.getValue();
        Long timestamp = functionValue.getTimestamp();
        if (value instanceof Number) {
            double tmpValue;
            if (!this.isNumber) {
                this.isNumber = true;
            }
            if ((tmpValue = ((Number)value).doubleValue()) >= this.doubleValue) {
                this.doubleValue = tmpValue;
                this.setTimestamp(timestamp);
                this.setRelatedValues(relatedValues);
            }
        } else if (value instanceof String) {
            String tmpValue = (String)value;
            if (!this.isString) {
                this.isString = true;
                this.stringValue = tmpValue;
                this.setTimestamp(timestamp);
                this.setRelatedValues(relatedValues);
            } else if (tmpValue.compareTo(this.stringValue) >= 0) {
                this.stringValue = tmpValue;
                this.setTimestamp(timestamp);
                this.setRelatedValues(relatedValues);
            }
        }
    }
}

