/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.execution.QueryStateMachine;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.scheduler.IFragInstanceStateTracker;
import org.apache.iotdb.mpp.rpc.thrift.TFetchFragmentInstanceStateReq;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceStateResp;
import org.apache.thrift.TException;

public abstract class AbstractFragInsStateTracker
implements IFragInstanceStateTracker {
    protected QueryStateMachine stateMachine;
    protected ScheduledExecutorService scheduledExecutor;
    protected List<FragmentInstance> instances;
    protected final String localhostIpAddr;
    protected final int localhostInternalPort;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager;

    public AbstractFragInsStateTracker(QueryStateMachine stateMachine, ScheduledExecutorService scheduledExecutor, List<FragmentInstance> instances, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager) {
        this.stateMachine = stateMachine;
        this.scheduledExecutor = scheduledExecutor;
        this.instances = instances;
        this.internalServiceClientManager = internalServiceClientManager;
        this.localhostIpAddr = IoTDBDescriptor.getInstance().getConfig().getInternalAddress();
        this.localhostInternalPort = IoTDBDescriptor.getInstance().getConfig().getInternalPort();
    }

    @Override
    public abstract void start();

    @Override
    public abstract void abort();

    protected FragmentInstanceState fetchState(FragmentInstance instance) throws TException, IOException {
        TEndPoint endPoint = instance.getHostDataNode().internalEndPoint;
        if (this.isInstanceRunningLocally(endPoint)) {
            FragmentInstanceInfo info = FragmentInstanceManager.getInstance().getInstanceInfo(instance.getId());
            if (info != null) {
                return info.getState();
            }
            return FragmentInstanceState.NO_SUCH_INSTANCE;
        }
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)this.internalServiceClientManager.borrowClient((Object)endPoint);){
            TFragmentInstanceStateResp resp = client.fetchFragmentInstanceState(new TFetchFragmentInstanceStateReq(this.getTId(instance)));
            FragmentInstanceState fragmentInstanceState = FragmentInstanceState.valueOf(resp.state);
            return fragmentInstanceState;
        }
    }

    private boolean isInstanceRunningLocally(TEndPoint endPoint) {
        return this.localhostIpAddr.equals(endPoint.getIp()) && this.localhostInternalPort == endPoint.port;
    }

    private TFragmentInstanceId getTId(FragmentInstance instance) {
        return new TFragmentInstanceId(instance.getId().getQueryId().getId(), instance.getId().getFragmentId().getId(), instance.getId().getInstanceId());
    }
}

