/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public enum AggregationStep {
    PARTIAL(InputType.RAW, true),
    FINAL(InputType.PARTIAL, false),
    INTERMEDIATE(InputType.PARTIAL, true),
    SINGLE(InputType.RAW, false),
    STATIC(InputType.FINAL, false);

    private final InputType inputType;
    private final boolean outputPartial;

    private AggregationStep(InputType inputType, boolean outputPartial) {
        this.inputType = inputType;
        this.outputPartial = outputPartial;
    }

    public boolean isInputRaw() {
        return this.inputType == InputType.RAW;
    }

    public boolean isInputPartial() {
        return this.inputType == InputType.PARTIAL;
    }

    public boolean isInputFinal() {
        return this.inputType == InputType.FINAL;
    }

    public boolean isOutputPartial() {
        return this.outputPartial;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((Boolean)this.isInputRaw(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isOutputPartial(), (ByteBuffer)byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((Boolean)this.isInputRaw(), (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isOutputPartial(), (OutputStream)stream);
    }

    public static AggregationStep deserialize(ByteBuffer byteBuffer) {
        boolean isInputRaw = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        boolean isOutputPartial = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (isInputRaw && isOutputPartial) {
            return PARTIAL;
        }
        if (!isInputRaw && isOutputPartial) {
            return INTERMEDIATE;
        }
        if (isInputRaw) {
            return SINGLE;
        }
        return FINAL;
    }

    private static enum InputType {
        RAW,
        PARTIAL,
        FINAL;

    }
}

