/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryTimeoutRuntimeException;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.execution.QueryState;
import org.apache.iotdb.db.mpp.execution.QueryStateMachine;
import org.apache.iotdb.db.mpp.execution.exchange.ISourceHandle;
import org.apache.iotdb.db.mpp.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.Analyzer;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.constant.DataNodeEndPoints;
import org.apache.iotdb.db.mpp.plan.execution.ExecutionResult;
import org.apache.iotdb.db.mpp.plan.execution.IQueryExecution;
import org.apache.iotdb.db.mpp.plan.execution.memory.MemorySourceHandle;
import org.apache.iotdb.db.mpp.plan.execution.memory.StatementMemorySource;
import org.apache.iotdb.db.mpp.plan.execution.memory.StatementMemorySourceContext;
import org.apache.iotdb.db.mpp.plan.execution.memory.StatementMemorySourceVisitor;
import org.apache.iotdb.db.mpp.plan.optimization.PlanOptimizer;
import org.apache.iotdb.db.mpp.plan.planner.LogicalPlanner;
import org.apache.iotdb.db.mpp.plan.planner.distribution.DistributionPlanner;
import org.apache.iotdb.db.mpp.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.scheduler.ClusterScheduler;
import org.apache.iotdb.db.mpp.plan.scheduler.IScheduler;
import org.apache.iotdb.db.mpp.plan.scheduler.StandaloneScheduler;
import org.apache.iotdb.db.mpp.plan.scheduler.load.LoadTsFileScheduler;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecution
implements IQueryExecution {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecution.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final int MAX_RETRY_COUNT = 3;
    private static final long RETRY_INTERVAL_IN_MS = 2000L;
    private int retryCount = 0;
    private final MPPQueryContext context;
    private IScheduler scheduler;
    private final QueryStateMachine stateMachine;
    private final List<PlanOptimizer> planOptimizers;
    private final Statement rawStatement;
    private Analysis analysis;
    private LogicalQueryPlan logicalPlan;
    private DistributedQueryPlan distributedPlan;
    private final ExecutorService executor;
    private final ExecutorService writeOperationExecutor;
    private final ScheduledExecutorService scheduledExecutor;
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;
    private ISourceHandle resultHandle;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager;

    public QueryExecution(Statement statement, MPPQueryContext context, ExecutorService executor, ExecutorService writeOperationExecutor, ScheduledExecutorService scheduledExecutor, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager) {
        this.rawStatement = statement;
        this.executor = executor;
        this.writeOperationExecutor = writeOperationExecutor;
        this.scheduledExecutor = scheduledExecutor;
        this.context = context;
        this.planOptimizers = new ArrayList<PlanOptimizer>();
        this.analysis = this.analyze(statement, context, partitionFetcher, schemaFetcher);
        this.stateMachine = new QueryStateMachine(context.getQueryId(), executor);
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
        this.internalServiceClientManager = internalServiceClientManager;
        this.stateMachine.addStateChangeListener(state -> {
            try (SetThreadName queryName = new SetThreadName(context.getQueryId().getId());){
                if (!state.isDone()) {
                    return;
                }
                this.stop();
                if (state == QueryState.FAILED || state == QueryState.ABORTED || state == QueryState.CANCELED) {
                    logger.info("[ReleaseQueryResource] state is: {}", (Object)state);
                    this.releaseResource();
                }
            }
        });
    }

    @Override
    public void start() {
        if (this.skipExecute()) {
            logger.info("[SkipExecute]");
            if (this.context.getQueryType() == QueryType.WRITE && this.analysis.isFailed()) {
                this.stateMachine.transitionToFailed(new RuntimeException(this.analysis.getFailMessage()));
            } else {
                this.constructResultForMemorySource();
                this.stateMachine.transitionToRunning();
            }
            return;
        }
        long remainTime = this.context.getTimeOut() - (System.currentTimeMillis() - this.context.getStartTime());
        if (remainTime <= 0L) {
            throw new QueryTimeoutRuntimeException();
        }
        this.context.setTimeOut(remainTime);
        this.doLogicalPlan();
        this.doDistributedPlan();
        this.stateMachine.transitionToPlanned();
        if (this.context.getQueryType() == QueryType.READ) {
            this.initResultHandle();
        }
        this.schedule();
    }

    private ExecutionResult retry() {
        if (this.retryCount >= 3) {
            logger.warn("[ReachMaxRetryCount]");
            this.stateMachine.transitionToFailed();
            return this.getStatus();
        }
        logger.warn("error when executing query. {}", (Object)this.stateMachine.getFailureMessage());
        this.stopAndCleanup();
        logger.info("[WaitBeforeRetry] wait {}ms.", (Object)2000L);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            logger.error("interrupted when waiting retry");
            Thread.currentThread().interrupt();
        }
        ++this.retryCount;
        logger.info("[Retry] retry count is: {}", (Object)this.retryCount);
        this.stateMachine.transitionToQueued();
        this.partitionFetcher.invalidAllCache();
        this.context.prepareForRetry();
        this.analysis = this.analyze(this.rawStatement, this.context, this.partitionFetcher, this.schemaFetcher);
        this.start();
        return this.getStatus();
    }

    private boolean skipExecute() {
        return this.analysis.isFinishQueryAfterAnalyze() || this.context.getQueryType() == QueryType.READ && !this.analysis.hasDataSource();
    }

    private void constructResultForMemorySource() {
        StatementMemorySource memorySource = (StatementMemorySource)new StatementMemorySourceVisitor().process(this.analysis.getStatement(), new StatementMemorySourceContext(this.context, this.analysis));
        this.resultHandle = new MemorySourceHandle(memorySource.getTsBlock());
        this.analysis.setRespDatasetHeader(memorySource.getDatasetHeader());
    }

    private Analysis analyze(Statement statement, MPPQueryContext context, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        return new Analyzer(context, partitionFetcher, schemaFetcher).analyze(statement);
    }

    private void schedule() {
        if (this.rawStatement instanceof LoadTsFileStatement) {
            this.scheduler = new LoadTsFileScheduler(this.distributedPlan, this.context, this.stateMachine, this.internalServiceClientManager);
            this.scheduler.start();
            return;
        }
        this.scheduler = config.isClusterMode() ? new ClusterScheduler(this.context, this.stateMachine, this.distributedPlan.getInstances(), this.context.getQueryType(), this.executor, this.writeOperationExecutor, this.scheduledExecutor, this.internalServiceClientManager) : new StandaloneScheduler(this.context, this.stateMachine, this.distributedPlan.getInstances(), this.context.getQueryType(), this.scheduledExecutor, this.internalServiceClientManager);
        this.scheduler.start();
    }

    public void doLogicalPlan() {
        LogicalPlanner planner = new LogicalPlanner(this.context, this.planOptimizers);
        this.logicalPlan = planner.plan(this.analysis);
        if (this.isQuery()) {
            logger.info("logical plan is: \n {}", (Object)PlanNodeUtil.nodeToString(this.logicalPlan.getRootNode()));
        }
    }

    public void doDistributedPlan() {
        DistributionPlanner planner = new DistributionPlanner(this.analysis, this.logicalPlan);
        this.distributedPlan = planner.planFragments();
        if (this.isQuery()) {
            logger.info("distribution plan done. Fragment instance count is {}, details is: \n {}", (Object)this.distributedPlan.getInstances().size(), (Object)this.printFragmentInstances(this.distributedPlan.getInstances()));
        }
    }

    private String printFragmentInstances(List<FragmentInstance> instances) {
        StringBuilder ret = new StringBuilder();
        for (FragmentInstance instance : instances) {
            ret.append(System.lineSeparator()).append(instance);
        }
        return ret.toString();
    }

    @Override
    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    @Override
    public void stopAndCleanup() {
        this.stop();
        this.releaseResource();
    }

    private void releaseResource() {
        if (this.resultHandle != null) {
            this.resultHandle.abort();
        }
    }

    @Override
    public Optional<TsBlock> getBatchResult() throws IoTDBException {
        Preconditions.checkArgument((this.resultHandle != null ? 1 : 0) != 0, (Object)"ResultHandle in Coordinator should be init firstly.");
        try {
            block9: {
                TsBlock res;
                do {
                    if (this.resultHandle.isAborted()) {
                        logger.warn("[ResultHandleAborted]");
                        this.stateMachine.transitionToAborted();
                        if (this.stateMachine.getFailureStatus() != null) {
                            throw new IoTDBException(this.stateMachine.getFailureStatus().getMessage(), this.stateMachine.getFailureStatus().code);
                        }
                        throw new IoTDBException(this.stateMachine.getFailureMessage(), TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode());
                    }
                    if (this.resultHandle.isFinished()) {
                        logger.info("[ResultHandleFinished]");
                        this.stateMachine.transitionToFinished();
                        return Optional.empty();
                    }
                    ListenableFuture<?> blocked = this.resultHandle.isBlocked();
                    blocked.get();
                    if (this.resultHandle.isFinished()) break block9;
                } while ((res = this.resultHandle.receive()) == null);
                return Optional.of(res);
            }
            return Optional.empty();
        }
        catch (CancellationException | ExecutionException e) {
            this.stateMachine.transitionToFailed(e.getCause() != null ? e.getCause() : e);
            if (this.stateMachine.getFailureStatus() != null) {
                throw new IoTDBException(this.stateMachine.getFailureStatus().getMessage(), this.stateMachine.getFailureStatus().code);
            }
            Throwable t = e.getCause() == null ? e : e.getCause();
            Throwables.throwIfUnchecked((Throwable)t);
            throw new IoTDBException(t, TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode());
        }
        catch (InterruptedException e) {
            this.stateMachine.transitionToFailed(e);
            Thread.currentThread().interrupt();
            throw new IoTDBException((Throwable)e, TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode());
        }
        catch (Throwable t) {
            this.stateMachine.transitionToFailed(t);
            throw t;
        }
    }

    @Override
    public boolean hasNextResult() {
        return this.resultHandle != null && !this.resultHandle.isFinished();
    }

    @Override
    public int getOutputValueColumnCount() {
        return this.analysis.getRespDatasetHeader().getOutputValueColumnCount();
    }

    @Override
    public DatasetHeader getDatasetHeader() {
        return this.analysis.getRespDatasetHeader();
    }

    @Override
    public ExecutionResult getStatus() {
        try {
            if (this.stateMachine.getState() == QueryState.FINISHED) {
                return this.getExecutionResult(QueryState.FINISHED);
            }
            SettableFuture future = SettableFuture.create();
            this.stateMachine.addStateChangeListener(state -> {
                if (state == QueryState.RUNNING || state.isDone() || state == QueryState.PENDING_RETRY) {
                    future.set((Object)state);
                }
            });
            QueryState state2 = (QueryState)((Object)future.get());
            if (state2 == QueryState.PENDING_RETRY) {
                return this.retry();
            }
            return this.getExecutionResult(state2);
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return new ExecutionResult(this.context.getQueryId(), this.stateMachine.getFailureStatus() == null ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)this.stateMachine.getFailureMessage()) : this.stateMachine.getFailureStatus());
        }
    }

    private void initResultHandle() {
        TEndPoint upstreamEndPoint = this.context.getResultNodeContext().getUpStreamEndpoint();
        this.resultHandle = DataNodeEndPoints.isSameNode(upstreamEndPoint) ? MPPDataExchangeService.getInstance().getMPPDataExchangeManager().createLocalSourceHandle(this.context.getResultNodeContext().getVirtualFragmentInstanceId().toThrift(), this.context.getResultNodeContext().getVirtualResultNodeId().getId(), this.context.getResultNodeContext().getUpStreamFragmentInstanceId().toThrift(), this.stateMachine::transitionToFailed) : MPPDataExchangeService.getInstance().getMPPDataExchangeManager().createSourceHandle(this.context.getResultNodeContext().getVirtualFragmentInstanceId().toThrift(), this.context.getResultNodeContext().getVirtualResultNodeId().getId(), upstreamEndPoint, this.context.getResultNodeContext().getUpStreamFragmentInstanceId().toThrift(), this.stateMachine::transitionToFailed);
    }

    private ExecutionResult getExecutionResult(QueryState state) {
        TSStatusCode statusCode = this.context.getQueryType() == QueryType.WRITE && this.analysis.isFailed() ? (state == QueryState.FINISHED ? TSStatusCode.SUCCESS_STATUS : TSStatusCode.WRITE_PROCESS_ERROR) : (state == QueryState.FINISHED || state == QueryState.RUNNING ? TSStatusCode.SUCCESS_STATUS : TSStatusCode.QUERY_PROCESS_ERROR);
        TSStatus tsstatus = RpcUtils.getStatus((TSStatusCode)statusCode, (String)this.stateMachine.getFailureMessage());
        if (state.isDone() && this.stateMachine.getFailureStatus() != null) {
            tsstatus = this.stateMachine.getFailureStatus();
        }
        if (this.analysis.getStatement() instanceof InsertBaseStatement && !this.analysis.isFinishQueryAfterAnalyze()) {
            InsertBaseStatement insertStatement = (InsertBaseStatement)this.analysis.getStatement();
            List<Object> redirectNodeList = config.isClusterMode() ? insertStatement.collectRedirectInfo(this.analysis.getDataPartitionInfo()) : Collections.emptyList();
            if (insertStatement instanceof InsertRowsStatement || insertStatement instanceof InsertMultiTabletsStatement) {
                if (statusCode == TSStatusCode.SUCCESS_STATUS) {
                    ArrayList<TSStatus> subStatus = new ArrayList<TSStatus>();
                    tsstatus.setCode(TSStatusCode.NEED_REDIRECTION.getStatusCode());
                    for (TEndPoint tEndPoint : redirectNodeList) {
                        subStatus.add(StatusUtils.getStatus((TSStatusCode)TSStatusCode.NEED_REDIRECTION).setRedirectNode(tEndPoint));
                    }
                    tsstatus.setSubStatus(subStatus);
                }
            } else if (config.isClusterMode()) {
                tsstatus.setRedirectNode((TEndPoint)redirectNodeList.get(0));
            }
        }
        return new ExecutionResult(this.context.getQueryId(), tsstatus);
    }

    public DistributedQueryPlan getDistributedPlan() {
        return this.distributedPlan;
    }

    public LogicalQueryPlan getLogicalPlan() {
        return this.logicalPlan;
    }

    @Override
    public boolean isQuery() {
        return this.context.getQueryType() == QueryType.READ;
    }

    @Override
    public String getQueryId() {
        return this.context.getQueryId().getId();
    }

    public String toString() {
        return String.format("QueryExecution[%s]", this.context.getQueryId());
    }
}

