/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.localconfignode;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDataPartitionTable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDataPartitionTable.class);
    private String storageGroupName;
    private final int regionNum;
    private DataRegionId[] regionIds;

    public LocalDataPartitionTable(String storageGroupName, List<DataRegionId> regions) {
        this.storageGroupName = storageGroupName;
        this.regionNum = regions.size();
        regions.sort(Comparator.comparingInt(ConsensusGroupId::getId));
        this.regionIds = new DataRegionId[regions.size()];
        for (int i = 0; i < regions.size(); ++i) {
            this.regionIds[i] = regions.get(i);
            DataRegionIdGenerator.getInstance().setIfGreater(this.regionIds[i].getId());
        }
    }

    public LocalDataPartitionTable(String storageGroupName) {
        this.storageGroupName = storageGroupName;
        this.regionNum = IoTDBDescriptor.getInstance().getConfig().getDataRegionNum();
        this.regionIds = new DataRegionId[this.regionNum];
    }

    public DataRegionId getDataRegionId(PartialPath path) {
        int idx = Math.abs(path.hashCode() % this.regionNum);
        return this.regionIds[idx];
    }

    public List<DataRegionId> getAllDataRegionId() {
        return Arrays.asList(this.regionIds);
    }

    public synchronized DataRegionId getDataRegionWithAutoExtension(PartialPath path) {
        int idx = Math.abs(path.hashCode() % this.regionNum);
        if (this.regionIds[idx] == null) {
            int nextId = DataRegionIdGenerator.getInstance().getNextId();
            this.regionIds[idx] = new DataRegionId(nextId);
        }
        return this.regionIds[idx];
    }

    public void clear() {
        this.regionIds = null;
    }

    public static class DataRegionIdGenerator {
        private static final DataRegionIdGenerator INSTANCE = new DataRegionIdGenerator();
        private final AtomicInteger idCounter = new AtomicInteger(0);

        public static DataRegionIdGenerator getInstance() {
            return INSTANCE;
        }

        public void setCurrentId(int id) {
            this.idCounter.set(id);
        }

        public int getNextId() {
            return this.idCounter.getAndIncrement();
        }

        public void setIfGreater(int id) {
            int originVal = this.idCounter.get();
            while (originVal <= id && !this.idCounter.compareAndSet(originVal, id + 1)) {
                originVal = this.idCounter.get();
            }
        }

        public void reset() {
            this.idCounter.set(0);
        }
    }
}

