/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.cross.ICrossSpaceSelector;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.CrossSpaceCompactionResource;
import org.apache.iotdb.db.engine.compaction.cross.utils.AbstractCompactionEstimator;
import org.apache.iotdb.db.engine.compaction.task.ICompactionSelector;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteCrossSpaceCompactionSelector
implements ICrossSpaceSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final int SELECT_WARN_THRESHOLD = 10;
    protected String logicalStorageGroupName;
    protected String dataRegionId;
    protected long timePartition;
    protected TsFileManager tsFileManager;
    private CrossSpaceCompactionResource resource;
    private long totalCost;
    private long totalSize;
    private final long memoryBudget;
    private final int maxCrossCompactionFileNum;
    private final long maxCrossCompactionFileSize;
    private List<TsFileResource> selectedUnseqFiles;
    private List<TsFileResource> selectedSeqFiles;
    private Collection<Integer> tmpSelectedSeqFiles;
    private boolean[] seqSelected;
    private int seqSelectedNum;
    private AbstractCompactionEstimator compactionEstimator;

    public RewriteCrossSpaceCompactionSelector(String logicalStorageGroupName, String dataRegionId, long timePartition, TsFileManager tsFileManager) {
        this.logicalStorageGroupName = logicalStorageGroupName;
        this.dataRegionId = dataRegionId;
        this.timePartition = timePartition;
        this.tsFileManager = tsFileManager;
        this.memoryBudget = (long)((double)(SystemInfo.getInstance().getMemorySizeForCompaction() / (long)IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread()) * config.getUsableCompactionMemoryProportion());
        this.maxCrossCompactionFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxCrossCompactionCandidateFileNum();
        this.maxCrossCompactionFileSize = IoTDBDescriptor.getInstance().getConfig().getMaxCrossCompactionCandidateFileSize();
        this.compactionEstimator = ICompactionSelector.getCompactionEstimator(IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer(), false);
    }

    private List[] select() throws MergeException {
        long startTime = System.currentTimeMillis();
        try {
            LOGGER.debug("Selecting merge candidates from {} seqFile, {} unseqFiles", (Object)this.resource.getSeqFiles().size(), (Object)this.resource.getUnseqFiles().size());
            this.selectSourceFiles();
            if (this.selectedUnseqFiles.isEmpty()) {
                LOGGER.debug("No merge candidates are found");
                List[] listArray = new List[]{};
                return listArray;
            }
        }
        catch (IOException e) {
            throw new MergeException(e);
        }
        finally {
            try {
                this.compactionEstimator.clear();
            }
            catch (IOException e) {
                throw new MergeException(e);
            }
        }
        LOGGER.info("Selected merge candidates, {} seqFiles, {} unseqFiles, total memory cost {}, time consumption {}ms", new Object[]{this.selectedSeqFiles.size(), this.selectedUnseqFiles.size(), this.totalCost, System.currentTimeMillis() - startTime});
        return new List[]{this.selectedSeqFiles, this.selectedUnseqFiles};
    }

    void selectSourceFiles() throws IOException {
        TsFileResource unseqFile;
        this.tmpSelectedSeqFiles = new HashSet<Integer>();
        this.seqSelected = new boolean[this.resource.getSeqFiles().size()];
        this.seqSelectedNum = 0;
        this.selectedSeqFiles = new ArrayList<TsFileResource>();
        this.selectedUnseqFiles = new ArrayList<TsFileResource>();
        this.totalCost = 0L;
        this.totalSize = 0L;
        int unseqIndex = 0;
        long startTime = System.currentTimeMillis();
        long timeConsumption = 0L;
        long timeLimit = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionFileSelectionTimeBudget();
        if (timeLimit < 0L) {
            timeLimit = Long.MAX_VALUE;
        }
        while (unseqIndex < this.resource.getUnseqFiles().size() && timeConsumption < timeLimit && (unseqFile = this.resource.getUnseqFiles().get(unseqIndex)).getTsFile().exists() && !unseqFile.isDeleted()) {
            boolean isSeqFilesValid;
            if (this.seqSelectedNum != this.resource.getSeqFiles().size()) {
                this.selectOverlappedSeqFiles(unseqFile);
            }
            if (!(isSeqFilesValid = this.checkIsSeqFilesValid())) {
                this.tmpSelectedSeqFiles.clear();
                break;
            }
            for (int i = 0; i < this.seqSelected.length; ++i) {
                if (!this.seqSelected[i]) continue;
                this.tmpSelectedSeqFiles.remove(i);
            }
            ArrayList<TsFileResource> tmpSelectedSeqFileResources = new ArrayList<TsFileResource>();
            for (int seqIndex : this.tmpSelectedSeqFiles) {
                TsFileResource tsFileResource = this.resource.getSeqFiles().get(seqIndex);
                tmpSelectedSeqFileResources.add(tsFileResource);
                this.totalSize += tsFileResource.getTsFileSize();
            }
            this.totalSize += unseqFile.getTsFileSize();
            long newCost = this.compactionEstimator.estimateCrossCompactionMemory(tmpSelectedSeqFileResources, unseqFile);
            if (!this.updateSelectedFiles(newCost, unseqFile)) break;
            this.tmpSelectedSeqFiles.clear();
            ++unseqIndex;
            timeConsumption = System.currentTimeMillis() - startTime;
        }
        for (int i = 0; i < this.seqSelected.length; ++i) {
            if (!this.seqSelected[i]) continue;
            this.selectedSeqFiles.add(this.resource.getSeqFiles().get(i));
        }
    }

    private boolean updateSelectedFiles(long newCost, TsFileResource unseqFile) {
        if (this.selectedUnseqFiles.size() == 0 || this.seqSelectedNum + this.selectedUnseqFiles.size() + 1 + this.tmpSelectedSeqFiles.size() <= this.maxCrossCompactionFileNum && this.totalSize <= this.maxCrossCompactionFileSize && this.totalCost + newCost < this.memoryBudget) {
            this.selectedUnseqFiles.add(unseqFile);
            for (Integer seqIdx : this.tmpSelectedSeqFiles) {
                if (this.seqSelected[seqIdx]) continue;
                ++this.seqSelectedNum;
                this.seqSelected[seqIdx.intValue()] = true;
            }
            this.totalCost += newCost;
            LOGGER.debug("Adding a new unseqFile {} and seqFiles {} as candidates, new cost {}, total cost {}", new Object[]{unseqFile, this.tmpSelectedSeqFiles, newCost, this.totalCost});
            return true;
        }
        return false;
    }

    private boolean checkIsSeqFilesValid() {
        for (Integer seqIdx : this.tmpSelectedSeqFiles) {
            if (!this.resource.getSeqFiles().get(seqIdx).isCompactionCandidate() && !this.resource.getSeqFiles().get(seqIdx).isCompacting() && this.resource.getSeqFiles().get(seqIdx).isClosed() && this.resource.getSeqFiles().get(seqIdx).getTsFile().exists()) continue;
            return false;
        }
        return true;
    }

    private void selectOverlappedSeqFiles(TsFileResource unseqFile) {
        for (String deviceId : unseqFile.getDevices()) {
            long unseqStartTime = unseqFile.getStartTime(deviceId);
            long unseqEndTime = unseqFile.getEndTime(deviceId);
            boolean noMoreOverlap = false;
            for (int i = 0; i < this.resource.getSeqFiles().size() && !noMoreOverlap; ++i) {
                TsFileResource seqFile = this.resource.getSeqFiles().get(i);
                if (!seqFile.mayContainsDevice(deviceId)) continue;
                int crossSpaceCompactionTimes = 0;
                try {
                    TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(seqFile.getTsFile().getName());
                    crossSpaceCompactionTimes = tsFileName.getCrossCompactionCnt();
                }
                catch (IOException e) {
                    LOGGER.warn("Meets IOException when selecting files for cross space compaction", (Throwable)e);
                }
                long seqEndTime = seqFile.getEndTime(deviceId);
                long seqStartTime = seqFile.getStartTime(deviceId);
                if (!seqFile.isClosed()) {
                    if (unseqEndTime < seqStartTime) continue;
                    this.tmpSelectedSeqFiles.add(i);
                    if (crossSpaceCompactionTimes < 10) continue;
                    LOGGER.warn("{} is selected for cross space compaction, it is overlapped with {} in device {}. Sequence file time range:[{},{}], Unsequence file time range:[{},{}]", new Object[]{seqFile.getTsFile().getAbsolutePath(), unseqFile.getTsFile().getAbsolutePath(), deviceId, seqStartTime, seqEndTime, unseqStartTime, unseqEndTime});
                    continue;
                }
                if (unseqEndTime <= seqEndTime) {
                    this.tmpSelectedSeqFiles.add(i);
                    noMoreOverlap = true;
                    if (crossSpaceCompactionTimes < 10) continue;
                    LOGGER.warn("{} is selected for cross space compaction, it is overlapped with {} in device {}. Sequence file time range:[{},{}], Unsequence file time range:[{},{}]", new Object[]{seqFile.getTsFile().getAbsolutePath(), unseqFile.getTsFile().getAbsolutePath(), deviceId, seqStartTime, seqEndTime, unseqStartTime, unseqEndTime});
                    continue;
                }
                if (unseqStartTime > seqEndTime) continue;
                this.tmpSelectedSeqFiles.add(i);
                if (crossSpaceCompactionTimes < 10) continue;
                LOGGER.warn("{} is selected for cross space compaction, it is overlapped with {} in device {}. Sequence file time range:[{},{}], Unsequence file time range:[{},{}]", new Object[]{seqFile.getTsFile().getAbsolutePath(), unseqFile.getTsFile().getAbsolutePath(), deviceId, seqStartTime, seqEndTime, unseqStartTime, unseqEndTime});
            }
        }
    }

    public List selectCrossSpaceTask(List<TsFileResource> sequenceFileList, List<TsFileResource> unsequenceFileList) {
        if (CompactionTaskManager.currentTaskNum.get() >= config.getConcurrentCompactionThread() || !config.isEnableCrossSpaceCompaction()) {
            return Collections.emptyList();
        }
        Iterator<TsFileResource> seqIterator = sequenceFileList.iterator();
        Iterator<TsFileResource> unSeqIterator = unsequenceFileList.iterator();
        ArrayList<TsFileResource> seqFileList = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> unSeqFileList = new ArrayList<TsFileResource>();
        while (seqIterator.hasNext()) {
            seqFileList.add(seqIterator.next());
        }
        while (unSeqIterator.hasNext()) {
            unSeqFileList.add(unSeqIterator.next());
        }
        if (seqFileList.isEmpty() || unSeqFileList.isEmpty()) {
            return Collections.emptyList();
        }
        long timeLowerBound = System.currentTimeMillis() - Long.MAX_VALUE;
        this.resource = new CrossSpaceCompactionResource(seqFileList, unSeqFileList, timeLowerBound);
        try {
            List[] mergeFiles = this.select();
            if (mergeFiles.length == 0) {
                return Collections.emptyList();
            }
            LOGGER.info("select files for cross compaction, sequence files: {}, unsequence files {}", (Object)mergeFiles[0], (Object)mergeFiles[1]);
            if (mergeFiles[0].size() > 0 && mergeFiles[1].size() > 0) {
                LOGGER.info("{} [Compaction] submit a task with {} sequence file and {} unseq files", new Object[]{this.logicalStorageGroupName + "-" + this.dataRegionId, mergeFiles[0].size(), mergeFiles[1].size()});
                return Collections.singletonList(new Pair((Object)mergeFiles[0], (Object)mergeFiles[1]));
            }
        }
        catch (MergeException e) {
            LOGGER.error("{} cannot select file for cross space compaction", (Object)this.logicalStorageGroupName, (Object)e);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> getCompactionMemoryCost() {
        return Collections.singletonList(this.totalCost);
    }
}

