/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.directories.strategy;

import java.util.List;
import org.apache.iotdb.commons.utils.JVMCommonUtils;
import org.apache.iotdb.db.conf.directories.strategy.DirectoryStrategy;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;

public class SequenceStrategy
extends DirectoryStrategy {
    private int currentIndex;

    @Override
    public void setFolders(List<String> folders) throws DiskSpaceInsufficientException {
        super.setFolders(folders);
        this.currentIndex = -1;
        for (int i = 0; i < folders.size(); ++i) {
            if (!JVMCommonUtils.hasSpace((String)folders.get(i))) continue;
            this.currentIndex = i;
            break;
        }
    }

    @Override
    public int nextFolderIndex() throws DiskSpaceInsufficientException {
        int index = this.currentIndex;
        this.currentIndex = this.tryGetNextIndex(index);
        return index;
    }

    private int tryGetNextIndex(int start) throws DiskSpaceInsufficientException {
        int index = (start + 1) % this.folders.size();
        while (!JVMCommonUtils.hasSpace((String)((String)this.folders.get(index)))) {
            if ((index = (index + 1) % this.folders.size()) != start) continue;
            throw new DiskSpaceInsufficientException(this.folders);
        }
        return index;
    }
}

