/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth;

import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.consensus.PartitionRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerResp;
import org.apache.iotdb.confignode.rpc.thrift.TCheckUserPrivilegesReq;
import org.apache.iotdb.confignode.rpc.thrift.TLoginReq;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.db.auth.AuthorizerManager;
import org.apache.iotdb.db.auth.IAuthorCache;
import org.apache.iotdb.db.auth.IAuthorityFetcher;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.client.DataNodeClientPoolFactory;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.statement.sys.AuthorStatement;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAuthorityFetcher
implements IAuthorityFetcher {
    private static final Logger logger = LoggerFactory.getLogger(ClusterAuthorityFetcher.class);
    private IAuthorCache iAuthorCache;
    private static final IClientManager<PartitionRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.ConfigNodeClientPoolFactory());

    public ClusterAuthorityFetcher(IAuthorCache iAuthorCache) {
        this.iAuthorCache = iAuthorCache;
    }

    @Override
    public TSStatus checkUserPrivileges(String username, List<String> allPath, int permission) {
        User user = this.iAuthorCache.getUserCache(username);
        if (user != null) {
            for (String path : allPath) {
                try {
                    if (user.checkPrivilege(path, permission)) continue;
                    if (user.getRoleList().isEmpty()) {
                        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION_ERROR);
                    }
                    boolean status = false;
                    for (String roleName : user.getRoleList()) {
                        Role role = this.iAuthorCache.getRoleCache(roleName);
                        if (role == null) {
                            this.iAuthorCache.invalidateCache(username, "");
                            return this.checkPath(username, allPath, permission);
                        }
                        status = role.checkPrivilege(path, permission);
                        if (!status) continue;
                        break;
                    }
                    if (status) continue;
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION_ERROR);
                }
                catch (AuthException e) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
                }
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        return this.checkPath(username, allPath, permission);
    }

    @Override
    public SettableFuture<ConfigTaskResult> operatePermission(AuthorStatement authorStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TAuthorizerReq authorizerReq = this.statementToAuthorizerReq(authorStatement);
            TSStatus tsStatus = configNodeClient.operatePermission(authorizerReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                logger.error("Failed to execute {} in config node, status is {}.", (Object)AuthorOperator.AuthorType.values()[authorizerReq.getAuthorType()].toString().toLowerCase(Locale.ROOT), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (IOException | TException e) {
            logger.error("Failed to connect to config node.");
            future.setException(e);
        }
        catch (AuthException e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> queryPermission(AuthorStatement authorStatement) {
        SettableFuture future = SettableFuture.create();
        TAuthorizerResp authorizerResp = new TAuthorizerResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TAuthorizerReq authorizerReq = this.statementToAuthorizerReq(authorStatement);
            authorizerResp = configNodeClient.queryPermission(authorizerReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != authorizerResp.getStatus().getCode()) {
                logger.error("Failed to execute {} in config node, status is {}.", (Object)AuthorOperator.AuthorType.values()[authorizerReq.getAuthorType()].toString().toLowerCase(Locale.ROOT), (Object)authorizerResp.getStatus());
                future.setException((Throwable)new IoTDBException(authorizerResp.getStatus().message, authorizerResp.getStatus().code));
            } else {
                AuthorizerManager.getInstance().buildTSBlock(authorizerResp.getAuthorizerInfo(), (SettableFuture<ConfigTaskResult>)future);
            }
        }
        catch (IOException | TException e) {
            logger.error("Failed to connect to config node.");
            authorizerResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Failed to connect to config node."));
            future.setException((Throwable)new IoTDBException(authorizerResp.getStatus().message, authorizerResp.getStatus().code));
        }
        catch (AuthException e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public IAuthorCache getAuthorCache() {
        return this.iAuthorCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSStatus checkUser(String username, String password) {
        User user = this.iAuthorCache.getUserCache(username);
        if (user != null) {
            if (password != null && AuthUtils.validatePassword((String)password, (String)user.getPassword())) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRONG_LOGIN_PASSWORD_ERROR, (String)"Authentication failed.");
        }
        TLoginReq req = new TLoginReq(username, password);
        TPermissionInfoResp status = null;
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            status = configNodeClient.login(req);
        }
        catch (IOException | TException e) {
            logger.error("Failed to connect to config node.");
            status = new TPermissionInfoResp();
            status.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Failed to connect to config node."));
        }
        finally {
            if (status == null) {
                status = new TPermissionInfoResp();
            }
        }
        if (status.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.iAuthorCache.putUserCache(username, this.cacheUser(status));
            return status.getStatus();
        }
        return status.getStatus();
    }

    public TSStatus checkPath(String username, List<String> allPath, int permission) {
        TPermissionInfoResp permissionInfoResp;
        TCheckUserPrivilegesReq req = new TCheckUserPrivilegesReq(username, allPath, permission);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            permissionInfoResp = configNodeClient.checkUserPrivileges(req);
        }
        catch (IOException | TException e) {
            logger.error("Failed to connect to config node.");
            permissionInfoResp = new TPermissionInfoResp();
            permissionInfoResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Failed to connect to config node."));
        }
        if (permissionInfoResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.iAuthorCache.putUserCache(username, this.cacheUser(permissionInfoResp));
            return permissionInfoResp.getStatus();
        }
        return permissionInfoResp.getStatus();
    }

    public User cacheUser(TPermissionInfoResp tPermissionInfoResp) {
        User user = new User();
        List privilegeList = tPermissionInfoResp.getUserInfo().getPrivilegeList();
        ArrayList<PathPrivilege> pathPrivilegeList = new ArrayList<PathPrivilege>();
        user.setName(tPermissionInfoResp.getUserInfo().getUsername());
        user.setPassword(tPermissionInfoResp.getUserInfo().getPassword());
        for (int i = 0; i < privilegeList.size(); ++i) {
            String path = (String)privilegeList.get(i);
            String privilege = (String)privilegeList.get(++i);
            pathPrivilegeList.add(this.toPathPrivilege(path, privilege));
        }
        user.setPrivilegeList(pathPrivilegeList);
        user.setRoleList(tPermissionInfoResp.getUserInfo().getRoleList());
        for (String roleName : tPermissionInfoResp.getRoleInfo().keySet()) {
            this.iAuthorCache.putRoleCache(roleName, this.cacheRole(roleName, tPermissionInfoResp));
        }
        return user;
    }

    public Role cacheRole(String roleName, TPermissionInfoResp tPermissionInfoResp) {
        Role role = new Role();
        List privilegeList = ((TRoleResp)tPermissionInfoResp.getRoleInfo().get(roleName)).getPrivilegeList();
        ArrayList<PathPrivilege> pathPrivilegeList = new ArrayList<PathPrivilege>();
        role.setName(((TRoleResp)tPermissionInfoResp.getRoleInfo().get(roleName)).getRoleName());
        for (int i = 0; i < privilegeList.size(); ++i) {
            String path = (String)privilegeList.get(i);
            String privilege = (String)privilegeList.get(++i);
            pathPrivilegeList.add(this.toPathPrivilege(path, privilege));
        }
        role.setPrivilegeList(pathPrivilegeList);
        return role;
    }

    private PathPrivilege toPathPrivilege(String path, String privilege) {
        PathPrivilege pathPrivilege = new PathPrivilege();
        String[] privileges = privilege.replace(" ", "").split(",");
        HashSet<Integer> privilegeIds = new HashSet<Integer>();
        for (String p : privileges) {
            privilegeIds.add(Integer.parseInt(p));
        }
        pathPrivilege.setPrivileges(privilegeIds);
        pathPrivilege.setPath(path);
        return pathPrivilege;
    }

    private TAuthorizerReq statementToAuthorizerReq(AuthorStatement authorStatement) throws AuthException {
        return new TAuthorizerReq(authorStatement.getAuthorType().ordinal(), authorStatement.getUserName() == null ? "" : authorStatement.getUserName(), authorStatement.getRoleName() == null ? "" : authorStatement.getRoleName(), authorStatement.getPassWord() == null ? "" : authorStatement.getPassWord(), authorStatement.getNewPassword() == null ? "" : authorStatement.getNewPassword(), AuthUtils.strToPermissions((String[])authorStatement.getPrivilegeList()), authorStatement.getNodeNameList() == null ? Collections.emptyList() : authorStatement.getNodeNameList().stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
    }
}

