/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.Collections;
import java.util.List;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.Preconditions;

public class SetConfigurationRequest
extends RaftClientRequest {
    private final List<RaftPeer> peers;
    private final List<RaftPeer> listeners;

    public SetConfigurationRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, List<RaftPeer> peers) {
        this(clientId, serverId, groupId, callId, peers, Collections.emptyList());
    }

    public SetConfigurationRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, List<RaftPeer> peers, List<RaftPeer> listeners) {
        super(clientId, serverId, groupId, callId, true, SetConfigurationRequest.writeRequestType());
        this.peers = peers != null ? Collections.unmodifiableList(peers) : Collections.emptyList();
        this.listeners = listeners != null ? Collections.unmodifiableList(listeners) : Collections.emptyList();
        Preconditions.assertUnique(this.peers);
        Preconditions.assertUnique(this.listeners);
    }

    public List<RaftPeer> getPeersInNewConf() {
        return this.peers;
    }

    public List<RaftPeer> getListenersInNewConf() {
        return this.listeners;
    }

    @Override
    public String toString() {
        return super.toString() + ", peers:" + this.getPeersInNewConf();
    }
}

