/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.Descriptor;
import javax.management.DescriptorKey;
import javax.management.ImmutableDescriptor;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.ManagedAnnotation;
import org.weakref.jmx.Nested;

final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static Descriptor buildDescriptor(Method annotatedMethod) {
        return AnnotationUtils.buildDescriptor(annotatedMethod.getAnnotations());
    }

    public static Descriptor buildDescriptor(Annotation ... annotations) {
        TreeMap<String, Object> fields = new TreeMap<String, Object>();
        for (Annotation annotation : AnnotationUtils.computeWalkSequence(annotations)) {
            AnnotationUtils.processAnnotation(annotation, fields);
        }
        return new ImmutableDescriptor(fields);
    }

    private static List<Annotation> computeWalkSequence(Annotation ... annotations) {
        HashSet<Annotation> seen = new HashSet<Annotation>();
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        AnnotationUtils.computeWalkSequence(seen, result, annotations);
        return new ArrayList<Annotation>(result);
    }

    private static void computeWalkSequence(Set<Annotation> seen, List<Annotation> result, Annotation ... annotations) {
        seen.addAll(Arrays.asList(annotations));
        for (Annotation annotation : annotations) {
            for (Annotation parent : annotation.annotationType().getAnnotations()) {
                if (seen.contains(parent)) continue;
                AnnotationUtils.computeWalkSequence(seen, result, parent);
            }
        }
        Collections.addAll(result, annotations);
    }

    private static void processAnnotation(Annotation annotation, Map<String, Object> fieldsCollector) {
        for (Method field : annotation.annotationType().getMethods()) {
            String[] value;
            DescriptorKey descriptorKey = field.getAnnotation(DescriptorKey.class);
            if (descriptorKey == null) continue;
            String name = descriptorKey.value();
            try {
                value = field.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                Throwable cause = e;
                if (e instanceof InvocationTargetException) {
                    cause = e.getCause();
                }
                throw new JmxException(JmxException.Reason.INVALID_ANNOTATION, cause, "Unexpected exception getting value from @DescriptorKey field type: annotationClass=%s, field=%s", annotation.annotationType().getName(), field.getName());
            }
            if (value == null) continue;
            if (value instanceof Class) {
                value = ((Class)value).getName();
            } else if (value instanceof Enum) {
                value = ((Enum)value).name();
            } else if (value.getClass().isArray()) {
                int i;
                String[] stringArray;
                Class<?> componentType = value.getClass().getComponentType();
                if (Class.class.equals(componentType)) {
                    Class[] classArray = (Class[])value;
                    stringArray = new String[classArray.length];
                    for (i = 0; i < classArray.length; ++i) {
                        if (classArray[i] == null) continue;
                        stringArray[i] = classArray[i].getName();
                    }
                    value = stringArray;
                } else if (componentType.isEnum()) {
                    Enum[] enumArray = (Enum[])value;
                    stringArray = new String[enumArray.length];
                    for (i = 0; i < enumArray.length; ++i) {
                        if (enumArray[i] == null) continue;
                        stringArray[i] = enumArray[i].name();
                    }
                    value = stringArray;
                }
            } else if (value instanceof Annotation) {
                throw new JmxException(JmxException.Reason.INVALID_ANNOTATION, "@DescriptorKey can not be applied to an annotation field type: annotationClass=%s, field=%s", annotation.annotationType().getName(), field.getName());
            }
            fieldsCollector.put(name, value);
        }
    }

    public static String getDescription(Descriptor descriptor, Method ... annotatedMethods) {
        for (Method annotatedMethod : annotatedMethods) {
            String description;
            if (annotatedMethod == null || (description = AnnotationUtils.getDescription(annotatedMethod)) == null) continue;
            return description;
        }
        Object descriptionValue = descriptor.getFieldValue("description");
        if (descriptionValue instanceof String) {
            return (String)descriptionValue;
        }
        return null;
    }

    public static String getDescription(Descriptor descriptor, Annotation ... annotatedMethod) {
        String description = AnnotationUtils.getDescription(annotatedMethod);
        if (description != null) {
            return description;
        }
        Object descriptionValue = descriptor.getFieldValue("description");
        if (descriptionValue instanceof String) {
            return (String)descriptionValue;
        }
        return null;
    }

    private static String getDescription(Method annotatedMethod) {
        return AnnotationUtils.getDescription(annotatedMethod.getAnnotations());
    }

    public static String getDescription(Annotation ... annotations) {
        String description = "";
        for (Annotation annotation : annotations) {
            try {
                Method descriptionMethod = annotation.annotationType().getMethod("description", new Class[0]);
                description = descriptionMethod.invoke((Object)annotation, new Object[0]).toString();
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return description;
    }

    public static Map<Method, Method> findManagedMethods(Class<?> clazz) {
        HashMap<Method, Method> result = new HashMap<Method, Method>();
        for (Method method : clazz.getMethods()) {
            Method managedMethod;
            if (method.isSynthetic() || method.isBridge() || (managedMethod = AnnotationUtils.findManagedMethod(clazz, method.getName(), method.getParameterTypes())) == null) continue;
            result.put(method, managedMethod);
        }
        return result;
    }

    private static Method findManagedMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        Method managedMethod;
        try {
            Method method = clazz.getDeclaredMethod(methodName, paramTypes);
            if (AnnotationUtils.isManagedMethod(method)) {
                return method;
            }
        }
        catch (NoSuchMethodException method) {
            // empty catch block
        }
        if (clazz.getSuperclass() != null && (managedMethod = AnnotationUtils.findManagedMethod(clazz.getSuperclass(), methodName, paramTypes)) != null) {
            return managedMethod;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            Method managedMethod2 = AnnotationUtils.findManagedMethod(iface, methodName, paramTypes);
            if (managedMethod2 == null) continue;
            return managedMethod2;
        }
        return null;
    }

    private static boolean isManagedMethod(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(ManagedAnnotation.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFlatten(Method method) {
        return method != null && AnnotationUtils.isAnnotationPresent(Flatten.class, new HashSet<Class<? extends Annotation>>(), method.getAnnotations());
    }

    public static boolean isNested(Method method) {
        return method != null && AnnotationUtils.isAnnotationPresent(Nested.class, new HashSet<Class<? extends Annotation>>(), method.getAnnotations());
    }

    private static boolean isAnnotationPresent(Class<? extends Annotation> annotationClass, Set<Class<? extends Annotation>> processedTypes, Annotation ... annotations) {
        for (Annotation annotation : annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return true;
        }
        for (Annotation annotation : annotations) {
            if (!processedTypes.add(annotation.annotationType()) || !AnnotationUtils.isAnnotationPresent(annotationClass, processedTypes, annotation.annotationType().getAnnotations())) continue;
            return true;
        }
        return false;
    }
}

