/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.snapshot;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.iotdb.consensus.multileader.snapshot.SnapshotFragment;

public class SnapshotFragmentReader {
    private static final int DEFAULT_FILE_FRAGMENT_SIZE = 0xA00000;
    private final String snapshotId;
    private final String filePath;
    private final SeekableByteChannel fileChannel;
    private final long fileSize;
    private final ByteBuffer buf;
    private long totalReadSize;
    private SnapshotFragment cachedSnapshotFragment;

    public SnapshotFragmentReader(String snapshotId, Path path) throws IOException {
        this.snapshotId = snapshotId;
        this.filePath = path.toAbsolutePath().toString();
        this.fileSize = Files.size(path);
        this.fileChannel = Files.newByteChannel(path, new OpenOption[0]);
        this.buf = ByteBuffer.allocate(0xA00000);
    }

    public boolean hasNext() throws IOException {
        this.buf.clear();
        int actualReadSize = this.fileChannel.read(this.buf);
        this.buf.flip();
        if (actualReadSize > 0) {
            this.cachedSnapshotFragment = new SnapshotFragment(this.snapshotId, this.filePath, this.fileSize, this.totalReadSize, actualReadSize, this.buf);
            this.totalReadSize += (long)actualReadSize;
            return true;
        }
        return false;
    }

    public SnapshotFragment next() {
        return this.cachedSnapshotFragment;
    }

    public void close() throws IOException {
        if (this.fileChannel != null) {
            this.fileChannel.close();
        }
    }
}

