/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader.logdispatcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class IndexController {
    private final Logger logger = LoggerFactory.getLogger(IndexController.class);
    private long lastFlushedIndex;
    private long currentIndex;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final String storageDir;
    private final String prefix;
    private final long initialIndex;
    private final long checkpointGap;

    public IndexController(String storageDir, String prefix, long initialIndex, long checkpointGap) {
        this.storageDir = storageDir;
        this.prefix = prefix + '-';
        this.checkpointGap = checkpointGap;
        this.initialIndex = initialIndex;
        this.restore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateAndGet(long index) {
        try {
            this.lock.writeLock().lock();
            long newCurrentIndex = Math.max(this.currentIndex, index);
            this.logger.debug("update index from currentIndex {} to {} for file prefix {} in {}", new Object[]{this.currentIndex, newCurrentIndex, this.prefix, this.storageDir});
            this.currentIndex = newCurrentIndex;
            this.checkPersist();
            long l = this.currentIndex;
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public long getCurrentIndex() {
        try {
            this.lock.readLock().lock();
            long l = this.currentIndex;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long getLastFlushedIndex() {
        return this.lastFlushedIndex;
    }

    private void checkPersist() {
        if (this.currentIndex - this.lastFlushedIndex >= this.checkpointGap) {
            this.persist();
        }
    }

    private void persist() {
        long flushIndex = this.currentIndex - this.currentIndex % this.checkpointGap;
        File oldFile = new File(this.storageDir, this.prefix + this.lastFlushedIndex);
        File newFile = new File(this.storageDir, this.prefix + flushIndex);
        try {
            if (oldFile.exists()) {
                FileUtils.moveFile((File)oldFile, (File)newFile);
                this.logger.info("version file updated, previous: {}, current: {}", (Object)oldFile.getAbsolutePath(), (Object)newFile.getAbsolutePath());
            } else {
                this.logger.error("failed to flush sync index. cannot find previous version file. previous: {}", (Object)this.lastFlushedIndex);
            }
            this.lastFlushedIndex = flushIndex;
        }
        catch (IOException e) {
            this.logger.error("Error occurred when flushing next version", (Throwable)e);
        }
    }

    private void restore() {
        File directory = new File(this.storageDir);
        File[] versionFiles = directory.listFiles((dir, name) -> name.startsWith(this.prefix));
        if (versionFiles != null && versionFiles.length > 0) {
            int i;
            long maxVersion = 0L;
            int maxVersionIndex = 0;
            for (i = 0; i < versionFiles.length; ++i) {
                long fileVersion = Long.parseLong(versionFiles[i].getName().split("-")[1]);
                if (fileVersion <= maxVersion) continue;
                maxVersion = fileVersion;
                maxVersionIndex = i;
            }
            this.lastFlushedIndex = maxVersion;
            for (i = 0; i < versionFiles.length; ++i) {
                if (i == maxVersionIndex) continue;
                try {
                    Files.delete(versionFiles[i].toPath());
                    continue;
                }
                catch (IOException e) {
                    this.logger.error("Delete outdated version file {} failed", (Object)versionFiles[i].getAbsolutePath(), (Object)e);
                }
            }
            this.currentIndex = this.lastFlushedIndex;
        } else {
            this.currentIndex = this.initialIndex;
            File versionFile = new File(directory, this.prefix + this.initialIndex);
            try {
                Files.createFile(versionFile.toPath(), new FileAttribute[0]);
                this.lastFlushedIndex = this.initialIndex;
            }
            catch (IOException e) {
                this.logger.error("Error occurred when creating new file {}", (Object)versionFile.getAbsolutePath(), (Object)e);
            }
        }
    }

    public void cleanupVersionFiles() throws IOException {
        File directory = new File(this.storageDir);
        File[] versionFiles = directory.listFiles((dir, name) -> name.startsWith(this.prefix));
        if (versionFiles != null && versionFiles.length > 0) {
            for (File versionFile : versionFiles) {
                Files.delete(versionFile.toPath());
            }
        }
    }
}

