/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.config;

import java.util.concurrent.TimeUnit;

public class MultiLeaderConfig {
    private final RPC rpc;
    private final Replication replication;

    private MultiLeaderConfig(RPC rpc, Replication replication) {
        this.rpc = rpc;
        this.replication = replication;
    }

    public RPC getRpc() {
        return this.rpc;
    }

    public Replication getReplication() {
        return this.replication;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Replication {
        private final int maxRequestPerBatch;
        private final int maxPendingBatch;
        private final int maxWaitingTimeForAccumulatingBatchInMs;
        private final long basicRetryWaitTimeMs;
        private final long maxRetryWaitTimeMs;
        private final long walThrottleThreshold;
        private final long throttleTimeOutMs;
        private final long checkpointGap;
        private final Long allocateMemoryForConsensus;

        private Replication(int maxRequestPerBatch, int maxPendingBatch, int maxWaitingTimeForAccumulatingBatchInMs, long basicRetryWaitTimeMs, long maxRetryWaitTimeMs, long walThrottleThreshold, long throttleTimeOutMs, long checkpointGap, long allocateMemoryForConsensus) {
            this.maxRequestPerBatch = maxRequestPerBatch;
            this.maxPendingBatch = maxPendingBatch;
            this.maxWaitingTimeForAccumulatingBatchInMs = maxWaitingTimeForAccumulatingBatchInMs;
            this.basicRetryWaitTimeMs = basicRetryWaitTimeMs;
            this.maxRetryWaitTimeMs = maxRetryWaitTimeMs;
            this.walThrottleThreshold = walThrottleThreshold;
            this.throttleTimeOutMs = throttleTimeOutMs;
            this.checkpointGap = checkpointGap;
            this.allocateMemoryForConsensus = allocateMemoryForConsensus;
        }

        public int getMaxRequestPerBatch() {
            return this.maxRequestPerBatch;
        }

        public int getMaxPendingBatch() {
            return this.maxPendingBatch;
        }

        public int getMaxWaitingTimeForAccumulatingBatchInMs() {
            return this.maxWaitingTimeForAccumulatingBatchInMs;
        }

        public long getBasicRetryWaitTimeMs() {
            return this.basicRetryWaitTimeMs;
        }

        public long getMaxRetryWaitTimeMs() {
            return this.maxRetryWaitTimeMs;
        }

        public long getWalThrottleThreshold() {
            return this.walThrottleThreshold;
        }

        public long getThrottleTimeOutMs() {
            return this.throttleTimeOutMs;
        }

        public long getCheckpointGap() {
            return this.checkpointGap;
        }

        public Long getAllocateMemoryForConsensus() {
            return this.allocateMemoryForConsensus;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private int maxRequestPerBatch = 30;
            private int maxPendingBatch = 5;
            private int maxWaitingTimeForAccumulatingBatchInMs = 500;
            private long basicRetryWaitTimeMs = TimeUnit.MILLISECONDS.toMillis(100L);
            private long maxRetryWaitTimeMs = TimeUnit.SECONDS.toMillis(20L);
            private long walThrottleThreshold = 0xC80000000L;
            private long throttleTimeOutMs = TimeUnit.SECONDS.toMillis(30L);
            private long checkpointGap = 500L;
            private long allocateMemoryForConsensus;

            public Builder setMaxRequestPerBatch(int maxRequestPerBatch) {
                this.maxRequestPerBatch = maxRequestPerBatch;
                return this;
            }

            public Builder setMaxPendingBatch(int maxPendingBatch) {
                this.maxPendingBatch = maxPendingBatch;
                return this;
            }

            public Builder setMaxWaitingTimeForAccumulatingBatchInMs(int maxWaitingTimeForAccumulatingBatchInMs) {
                this.maxWaitingTimeForAccumulatingBatchInMs = maxWaitingTimeForAccumulatingBatchInMs;
                return this;
            }

            public Builder setBasicRetryWaitTimeMs(long basicRetryWaitTimeMs) {
                this.basicRetryWaitTimeMs = basicRetryWaitTimeMs;
                return this;
            }

            public Builder setMaxRetryWaitTimeMs(long maxRetryWaitTimeMs) {
                this.maxRetryWaitTimeMs = maxRetryWaitTimeMs;
                return this;
            }

            public Builder setWalThrottleThreshold(long walThrottleThreshold) {
                this.walThrottleThreshold = walThrottleThreshold;
                return this;
            }

            public Builder setThrottleTimeOutMs(long throttleTimeOutMs) {
                this.throttleTimeOutMs = throttleTimeOutMs;
                return this;
            }

            public Builder setAllocateMemoryForConsensus(long allocateMemoryForConsensus) {
                this.allocateMemoryForConsensus = allocateMemoryForConsensus;
                return this;
            }

            public Replication build() {
                return new Replication(this.maxRequestPerBatch, this.maxPendingBatch, this.maxWaitingTimeForAccumulatingBatchInMs, this.basicRetryWaitTimeMs, this.maxRetryWaitTimeMs, this.walThrottleThreshold, this.throttleTimeOutMs, this.checkpointGap, this.allocateMemoryForConsensus);
            }
        }
    }

    public static class RPC {
        private final int rpcSelectorThreadNum;
        private final int rpcMinConcurrentClientNum;
        private final int rpcMaxConcurrentClientNum;
        private final int thriftServerAwaitTimeForStopService;
        private final boolean isRpcThriftCompressionEnabled;
        private final int selectorNumOfClientManager;
        private final int connectionTimeoutInMs;
        private final int thriftMaxFrameSize;

        private RPC(int rpcSelectorThreadNum, int rpcMinConcurrentClientNum, int rpcMaxConcurrentClientNum, int thriftServerAwaitTimeForStopService, boolean isRpcThriftCompressionEnabled, int selectorNumOfClientManager, int connectionTimeoutInMs, int thriftMaxFrameSize) {
            this.rpcSelectorThreadNum = rpcSelectorThreadNum;
            this.rpcMinConcurrentClientNum = rpcMinConcurrentClientNum;
            this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
            this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
            this.isRpcThriftCompressionEnabled = isRpcThriftCompressionEnabled;
            this.selectorNumOfClientManager = selectorNumOfClientManager;
            this.connectionTimeoutInMs = connectionTimeoutInMs;
            this.thriftMaxFrameSize = thriftMaxFrameSize;
        }

        public int getRpcSelectorThreadNum() {
            return this.rpcSelectorThreadNum;
        }

        public int getRpcMinConcurrentClientNum() {
            return this.rpcMinConcurrentClientNum;
        }

        public int getRpcMaxConcurrentClientNum() {
            return this.rpcMaxConcurrentClientNum;
        }

        public int getThriftServerAwaitTimeForStopService() {
            return this.thriftServerAwaitTimeForStopService;
        }

        public boolean isRpcThriftCompressionEnabled() {
            return this.isRpcThriftCompressionEnabled;
        }

        public int getSelectorNumOfClientManager() {
            return this.selectorNumOfClientManager;
        }

        public int getConnectionTimeoutInMs() {
            return this.connectionTimeoutInMs;
        }

        public int getThriftMaxFrameSize() {
            return this.thriftMaxFrameSize;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private int rpcSelectorThreadNum = 1;
            private int rpcMinConcurrentClientNum = Runtime.getRuntime().availableProcessors();
            private int rpcMaxConcurrentClientNum = 65535;
            private int thriftServerAwaitTimeForStopService = 60;
            private boolean isRpcThriftCompressionEnabled = false;
            private int selectorNumOfClientManager = 1;
            private int connectionTimeoutInMs = (int)TimeUnit.SECONDS.toMillis(20L);
            private int thriftMaxFrameSize = 0x20000000;

            public Builder setRpcSelectorThreadNum(int rpcSelectorThreadNum) {
                this.rpcSelectorThreadNum = rpcSelectorThreadNum;
                return this;
            }

            public Builder setRpcMinConcurrentClientNum(int rpcMinConcurrentClientNum) {
                this.rpcMinConcurrentClientNum = rpcMinConcurrentClientNum;
                return this;
            }

            public Builder setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
                this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
                return this;
            }

            public Builder setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
                this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
                return this;
            }

            public Builder setRpcThriftCompressionEnabled(boolean rpcThriftCompressionEnabled) {
                this.isRpcThriftCompressionEnabled = rpcThriftCompressionEnabled;
                return this;
            }

            public Builder setSelectorNumOfClientManager(int selectorNumOfClientManager) {
                this.selectorNumOfClientManager = selectorNumOfClientManager;
                return this;
            }

            public Builder setConnectionTimeoutInMs(int connectionTimeoutInMs) {
                this.connectionTimeoutInMs = connectionTimeoutInMs;
                return this;
            }

            public Builder setThriftMaxFrameSize(int thriftMaxFrameSize) {
                this.thriftMaxFrameSize = thriftMaxFrameSize;
                return this;
            }

            public RPC build() {
                return new RPC(this.rpcSelectorThreadNum, this.rpcMinConcurrentClientNum, this.rpcMaxConcurrentClientNum, this.thriftServerAwaitTimeForStopService, this.isRpcThriftCompressionEnabled, this.selectorNumOfClientManager, this.connectionTimeoutInMs, this.thriftMaxFrameSize);
            }
        }
    }

    public static class Builder {
        private RPC rpc;
        private Replication replication;

        public MultiLeaderConfig build() {
            return new MultiLeaderConfig(this.rpc != null ? this.rpc : new RPC.Builder().build(), this.replication != null ? this.replication : new Replication.Builder().build());
        }

        public Builder setRpc(RPC rpc) {
            this.rpc = rpc;
            return this;
        }

        public Builder setReplication(Replication replication) {
            this.replication = replication;
            return this;
        }
    }
}

