/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ExitUtils {
    public static ExitException getFirstExitException() {
        return States.INSTANCE.getFirstExitException();
    }

    public static boolean clear() {
        return States.INSTANCE.clearFirstExitException();
    }

    public static boolean isTerminated() {
        return ExitUtils.getFirstExitException() != null;
    }

    public static void assertNotTerminated() {
        if (ExitUtils.isTerminated()) {
            throw new AssertionError("Unexpected exit.", ExitUtils.getFirstExitException());
        }
    }

    public static void disableSystemExit() {
        States.INSTANCE.disableSystemExit();
    }

    public static void terminate(int status, String message, Throwable throwable, boolean throwExitException, Logger log) throws ExitException {
        if (log != null) {
            String s = "Terminating with exit status " + status + ": " + message;
            if (status == 0) {
                log.info(s, throwable);
            } else {
                log.error(s, throwable);
            }
        }
        if (!States.INSTANCE.isSystemExitDisabled()) {
            System.exit(status);
        }
        ExitException ee = new ExitException(status, message, throwable);
        States.INSTANCE.setFirstExitException(ee);
        if (throwExitException) {
            throw ee;
        }
    }

    public static void terminate(int status, String message, Throwable throwable, Logger log) {
        ExitUtils.terminate(status, message, throwable, true, log);
    }

    public static void terminate(int status, String message, Logger log) {
        ExitUtils.terminate(status, message, null, log);
    }

    public static void setTerminateOnUncaughtException(boolean terminateOnUncaughtException) {
        States.INSTANCE.setTerminateOnUncaughtException(terminateOnUncaughtException);
    }

    public static class States {
        private static final Logger LOG = LoggerFactory.getLogger(ExitUtils.class);
        private static final States INSTANCE = new States();
        private volatile boolean systemExitDisabled = false;
        private volatile boolean terminateOnUncaughtException = true;
        private final AtomicReference<ExitException> firstExitException = new AtomicReference();

        private States() {
            Thread.setDefaultUncaughtExceptionHandler((thread, exception) -> {
                if (this.terminateOnUncaughtException) {
                    ExitUtils.terminate(-1, thread + " has thrown an uncaught exception", exception, false, LOG);
                }
            });
        }

        private void setTerminateOnUncaughtException(boolean terminateOnUncaughtException) {
            this.terminateOnUncaughtException = terminateOnUncaughtException;
        }

        private void disableSystemExit() {
            this.systemExitDisabled = true;
        }

        private boolean isSystemExitDisabled() {
            return this.systemExitDisabled;
        }

        private ExitException getFirstExitException() {
            return this.firstExitException.get();
        }

        private boolean setFirstExitException(ExitException e) {
            Objects.requireNonNull(e, "e == null");
            return this.firstExitException.compareAndSet(null, e);
        }

        private boolean clearFirstExitException() {
            return this.firstExitException.getAndSet(null) != null;
        }
    }

    public static class ExitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final int status;

        ExitException(int status, String message, Throwable throwable) {
            super(message, throwable);
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

