/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.service;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.iotdb.commons.udf.service.UDFClassLoader;
import org.apache.iotdb.udf.api.UDTF;

public class UDFRegistrationInformation {
    private final String functionName;
    private final String className;
    private final List<String> uris;
    private final boolean isBuiltin;
    private Class<?> functionClass;

    public UDFRegistrationInformation(String functionName, String className, List<String> uris, boolean isBuiltin, Class<?> functionClass) {
        this.functionName = functionName;
        this.className = className;
        this.uris = uris;
        this.isBuiltin = isBuiltin;
        this.functionClass = functionClass;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getClassName() {
        return this.className;
    }

    public List<String> getUris() {
        return this.uris;
    }

    public boolean isBuiltin() {
        return this.isBuiltin;
    }

    public Class<?> getFunctionClass() {
        return this.functionClass;
    }

    public void updateFunctionClass(UDFClassLoader udfClassLoader) throws ClassNotFoundException {
        this.functionClass = Class.forName(this.className, true, udfClassLoader);
    }

    public boolean isUDTF() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.functionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) instanceof UDTF;
    }

    public boolean isUDAF() {
        return false;
    }
}

