/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.sync.metadata;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.exception.sync.PipeNotExistException;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.sync.persistence.SyncLogReader;
import org.apache.iotdb.commons.sync.persistence.SyncLogWriter;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeMessage;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.commons.sync.pipesink.PipeSink;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncMetadata
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncMetadata.class);
    private Map<String, PipeSink> pipeSinks;
    private PipeInfo runningPipe;
    private Map<String, Map<Long, PipeInfo>> pipes = new ConcurrentHashMap<String, Map<Long, PipeInfo>>();

    public SyncMetadata() {
        this.pipeSinks = new ConcurrentHashMap<String, PipeSink>();
    }

    public Map<String, PipeSink> getPipeSinks() {
        return this.pipeSinks;
    }

    public void setPipeSinks(Map<String, PipeSink> pipeSinks) {
        this.pipeSinks = pipeSinks;
    }

    public PipeInfo getRunningPipe() {
        return this.runningPipe;
    }

    public void setRunningPipe(PipeInfo runningPipe) {
        this.runningPipe = runningPipe;
    }

    public Map<String, Map<Long, PipeInfo>> getPipes() {
        return this.pipes;
    }

    public void setPipes(Map<String, Map<Long, PipeInfo>> pipes) {
        this.pipes = pipes;
    }

    public boolean isPipeSinkExist(String name) {
        return this.pipeSinks.containsKey(name);
    }

    public void checkAddPipeSink(String pipeSinkName) throws PipeSinkException {
        if (this.isPipeSinkExist(pipeSinkName)) {
            throw new PipeSinkException("There is a PipeSink named " + pipeSinkName + " in IoTDB, please drop it before recreation.");
        }
    }

    public void addPipeSink(PipeSink pipeSink) {
        this.pipeSinks.put(pipeSink.getPipeSinkName(), pipeSink);
    }

    public void checkDropPipeSink(String pipeSinkName) throws PipeSinkException {
        if (!this.isPipeSinkExist(pipeSinkName)) {
            throw new PipeSinkException("PipeSink " + pipeSinkName + " does not exist.");
        }
        if (this.runningPipe != null && this.runningPipe.getStatus() != PipeStatus.DROP && this.runningPipe.getPipeSinkName().equals(pipeSinkName)) {
            throw new PipeSinkException(String.format("Can not drop PipeSink %s, because Pipe %s is using it.", pipeSinkName, this.runningPipe.getPipeName()));
        }
    }

    public void dropPipeSink(String name) {
        this.pipeSinks.remove(name);
    }

    public PipeSink getPipeSink(String name) {
        return this.pipeSinks.getOrDefault(name, null);
    }

    public List<PipeSink> getAllPipeSink() {
        ArrayList<PipeSink> allPipeSinks = new ArrayList<PipeSink>();
        for (Map.Entry<String, PipeSink> entry : this.pipeSinks.entrySet()) {
            allPipeSinks.add(entry.getValue());
        }
        return allPipeSinks;
    }

    public void checkAddPipe(PipeInfo pipeInfo) throws PipeException {
        if (!this.isPipeSinkExist(pipeInfo.getPipeSinkName())) {
            throw new PipeException(String.format("can not find PIPESINK %s.", pipeInfo.getPipeSinkName()));
        }
        if (this.runningPipe != null && this.runningPipe.getStatus() != PipeStatus.DROP) {
            throw new PipeException(String.format("PIPE %s is %s, please retry after drop it.", this.runningPipe.getPipeName(), this.runningPipe.getStatus().name()));
        }
    }

    public void addPipe(PipeInfo pipeInfo) {
        this.runningPipe = pipeInfo;
        this.pipes.computeIfAbsent(this.runningPipe.getPipeName(), i -> new ConcurrentHashMap()).computeIfAbsent(this.runningPipe.getCreateTime(), i -> this.runningPipe);
    }

    public void setPipeStatus(String pipeName, PipeStatus status) throws PipeException {
        this.runningPipe.setStatus(status);
    }

    public PipeInfo getPipeInfo(String pipeName, long createTime) {
        return this.pipes.get(pipeName).get(createTime);
    }

    public List<PipeInfo> getAllPipeInfos() {
        ArrayList<PipeInfo> pipeInfos = new ArrayList<PipeInfo>();
        for (Map<Long, PipeInfo> timePipeInfoMap : this.pipes.values()) {
            pipeInfos.addAll(timePipeInfoMap.values());
        }
        return pipeInfos;
    }

    public PipeInfo getRunningPipeInfo() {
        return this.runningPipe;
    }

    public void checkIfPipeExist(String pipeName) throws PipeException {
        if (this.runningPipe == null || this.runningPipe.getStatus() == PipeStatus.DROP) {
            throw new PipeNotExistException(pipeName);
        }
        if (!this.runningPipe.getPipeName().equals(pipeName)) {
            throw new PipeException(String.format("PIPE %s is %s, please retry after drop it.", new Object[]{this.runningPipe.getPipeName(), this.runningPipe.getStatus()}));
        }
    }

    public void changePipeMessage(String pipeName, long createTime, PipeMessage.PipeMessageType messageType) {
        if (messageType.compareTo(this.pipes.get(pipeName).get(createTime).getMessageType()) > 0) {
            this.pipes.get(pipeName).get(createTime).setMessageType(messageType);
        }
    }

    @Override
    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, "syncService.log");
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        File tmpFile = new File(snapshotFile.getAbsolutePath() + "-" + UUID.randomUUID());
        try (SyncLogWriter writer = new SyncLogWriter(snapshotDir, tmpFile.getName());){
            for (PipeSink pipeSink : this.pipeSinks.values()) {
                writer.addPipeSink(pipeSink);
            }
            for (Map map : this.pipes.values()) {
                for (PipeInfo pipeInfo : map.values()) {
                    writer.addPipe(pipeInfo);
                    switch (pipeInfo.getStatus()) {
                        case RUNNING: {
                            writer.operatePipe(pipeInfo.getPipeName(), SyncOperation.START_PIPE);
                            break;
                        }
                        case STOP: {
                            writer.operatePipe(pipeInfo.getPipeName(), SyncOperation.STOP_PIPE);
                            break;
                        }
                        case DROP: {
                            writer.operatePipe(pipeInfo.getPipeName(), SyncOperation.DROP_PIPE);
                        }
                    }
                }
            }
        }
        return tmpFile.renameTo(snapshotFile);
    }

    @Override
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, "syncService.log");
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        SyncLogReader reader = new SyncLogReader(snapshotDir);
        reader.recover();
        this.setPipes(reader.getAllPipeInfos());
        this.setPipeSinks(reader.getAllPipeSinks());
        this.setRunningPipe(reader.getRunningPipeInfo());
    }
}

