/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.predefined.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class JvmThreadMetrics
implements IMetricSet {
    @Override
    public void bindTo(AbstractMetricService metricService) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        metricService.getOrCreateAutoGauge("jvm.threads.peak.threads", MetricLevel.IMPORTANT, threadBean, ThreadMXBean::getPeakThreadCount, new String[0]);
        metricService.getOrCreateAutoGauge("jvm.threads.daemon.threads", MetricLevel.IMPORTANT, threadBean, ThreadMXBean::getDaemonThreadCount, new String[0]);
        metricService.getOrCreateAutoGauge("jvm.threads.live.threads", MetricLevel.IMPORTANT, threadBean, ThreadMXBean::getThreadCount, new String[0]);
        try {
            threadBean.getAllThreadIds();
            for (Thread.State state : Thread.State.values()) {
                metricService.getOrCreateAutoGauge("jvm.threads.states.threads", MetricLevel.IMPORTANT, threadBean, bean -> JvmThreadMetrics.getThreadStateCount(bean, state), "state", JvmThreadMetrics.getStateTagValue(state));
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        metricService.remove(MetricType.GAUGE, "jvm.threads.peak.threads", new String[0]);
        metricService.remove(MetricType.GAUGE, "jvm.threads.daemon.threads", new String[0]);
        metricService.remove(MetricType.GAUGE, "jvm.threads.live.threads", new String[0]);
        try {
            threadBean.getAllThreadIds();
            for (Thread.State state : Thread.State.values()) {
                metricService.remove(MetricType.GAUGE, "jvm.threads.states.threads", "state", JvmThreadMetrics.getStateTagValue(state));
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    static long getThreadStateCount(ThreadMXBean threadBean, Thread.State state) {
        return Arrays.stream(threadBean.getThreadInfo(threadBean.getAllThreadIds())).filter(threadInfo -> threadInfo != null && threadInfo.getThreadState() == state).count();
    }

    private static String getStateTagValue(Thread.State state) {
        return state.name().toLowerCase().replace("_", "-");
    }
}

