/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.common.request;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;

public class IndexedConsensusRequest
implements IConsensusRequest {
    private final long searchIndex;
    private final long syncIndex;
    private List<IConsensusRequest> requests;
    private List<ByteBuffer> serializedRequests;
    private long serializedSize = 0L;

    public IndexedConsensusRequest(long searchIndex, List<IConsensusRequest> requests) {
        this.searchIndex = searchIndex;
        this.requests = requests;
        this.syncIndex = -1L;
    }

    public IndexedConsensusRequest(List<ByteBuffer> serializedRequests, long searchIndex) {
        this.searchIndex = searchIndex;
        this.serializedRequests = serializedRequests;
        for (ByteBuffer byteBuffer : serializedRequests) {
            this.serializedSize += (long)byteBuffer.capacity();
        }
        this.syncIndex = -1L;
    }

    public IndexedConsensusRequest(long searchIndex, long syncIndex, List<IConsensusRequest> requests) {
        this.searchIndex = searchIndex;
        this.requests = requests;
        this.syncIndex = syncIndex;
    }

    @Override
    public ByteBuffer serializeToByteBuffer() {
        throw new UnsupportedOperationException();
    }

    public List<IConsensusRequest> getRequests() {
        return this.requests;
    }

    public List<ByteBuffer> getSerializedRequests() {
        return this.serializedRequests;
    }

    public List<ByteBuffer> buildSerializedRequests() {
        LinkedList<ByteBuffer> result = new LinkedList<ByteBuffer>();
        this.requests.forEach(r -> result.add(r.serializeToByteBuffer()));
        return result;
    }

    public long getSerializedSize() {
        return this.serializedSize;
    }

    public long getSearchIndex() {
        return this.searchIndex;
    }

    public long getSyncIndex() {
        return this.syncIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedConsensusRequest that = (IndexedConsensusRequest)o;
        return this.searchIndex == that.searchIndex && this.requests.equals(that.requests);
    }

    public int hashCode() {
        return Objects.hash(this.searchIndex, this.requests);
    }
}

