/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.client.api.BlockingApi;
import org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ratis.client.retry.ClientRetryEvent;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.protocol.exceptions.AlreadyExistsException;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.protocol.exceptions.LeaderSteppingDownException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.protocol.exceptions.TransferLeadershipException;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockingImpl
implements BlockingApi {
    static final Logger LOG = LoggerFactory.getLogger(BlockingImpl.class);
    private final RaftClientImpl client;

    BlockingImpl(RaftClientImpl client) {
        this.client = Objects.requireNonNull(client, "client == null");
    }

    @Override
    public RaftClientReply send(Message message) throws IOException {
        return this.send(RaftClientRequest.writeRequestType(), message, null);
    }

    @Override
    public RaftClientReply sendReadOnly(Message message) throws IOException {
        return this.send(RaftClientRequest.readRequestType(), message, null);
    }

    @Override
    public RaftClientReply sendStaleRead(Message message, long minIndex, RaftPeerId server) throws IOException {
        return this.send(RaftClientRequest.staleReadRequestType((long)minIndex), message, server);
    }

    @Override
    public RaftClientReply watch(long index, RaftProtos.ReplicationLevel replication) throws IOException {
        return this.send(RaftClientRequest.watchRequestType((long)index, (RaftProtos.ReplicationLevel)replication), null, null);
    }

    private RaftClientReply send(RaftClientRequest.Type type, Message message, RaftPeerId server) throws IOException {
        if (!type.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
            Objects.requireNonNull(message, "message == null");
        }
        long callId = CallId.getAndIncrement();
        return this.sendRequestWithRetry(() -> this.client.newRaftClientRequest(server, callId, message, type, null));
    }

    RaftClientReply sendRequestWithRetry(final Supplier<RaftClientRequest> supplier) throws IOException {
        RaftClientImpl.PendingClientRequest pending = new RaftClientImpl.PendingClientRequest(){

            @Override
            public RaftClientRequest newRequestImpl() {
                return (RaftClientRequest)supplier.get();
            }
        };
        while (true) {
            RaftClientRequest request = pending.newRequest();
            IOException ioe = null;
            try {
                RaftClientReply reply = this.sendRequest(request);
                if (reply != null) {
                    return this.client.handleReply(request, reply);
                }
            }
            catch (AlreadyClosedException | AlreadyExistsException | GroupMismatchException | LeaderSteppingDownException | StateMachineException | TransferLeadershipException e) {
                throw e;
            }
            catch (IOException e) {
                ioe = e;
            }
            pending.incrementExceptionCount(ioe);
            ClientRetryEvent event = new ClientRetryEvent(request, ioe, pending);
            RetryPolicy retryPolicy = this.client.getRetryPolicy();
            RetryPolicy.Action action = retryPolicy.handleAttemptFailure((RetryPolicy.Event)event);
            TimeDuration sleepTime = this.client.getEffectiveSleepTime(ioe, action.getSleepTime());
            if (!action.shouldRetry()) {
                throw (IOException)this.client.noMoreRetries(event);
            }
            try {
                sleepTime.sleep();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("retry policy=" + retryPolicy);
            }
        }
    }

    private RaftClientReply sendRequest(RaftClientRequest request) throws IOException {
        RaftClientReply reply;
        LOG.debug("{}: send {}", (Object)this.client.getId(), (Object)request);
        try {
            reply = this.client.getClientRpc().sendRequest(request);
        }
        catch (GroupMismatchException gme) {
            throw gme;
        }
        catch (IOException ioe) {
            this.client.handleIOException(request, ioe);
            throw ioe;
        }
        LOG.debug("{}: receive {}", (Object)this.client.getId(), (Object)reply);
        reply = this.client.handleLeaderException(request, reply);
        reply = RaftClientImpl.handleRaftException(reply, Function.identity());
        return reply;
    }
}

