/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.sync;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.sync.PipeException;
import org.apache.iotdb.commons.sync.pipe.PipeInfo;
import org.apache.iotdb.commons.sync.pipe.PipeStatus;
import org.apache.iotdb.commons.sync.pipe.SyncOperation;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.sync.AbstractOperatePipeProcedure;
import org.apache.iotdb.confignode.procedure.state.sync.OperatePipeState;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.rpc.thrift.TPipeInfo;
import org.apache.iotdb.db.utils.sync.SyncPipeUtil;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePipeProcedure
extends AbstractOperatePipeProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreatePipeProcedure.class);
    private PipeInfo pipeInfo;

    public CreatePipeProcedure() {
    }

    public CreatePipeProcedure(TPipeInfo pipeInfo) throws PipeException {
        this.pipeInfo = SyncPipeUtil.parseTPipeInfoAsPipeInfo((TPipeInfo)pipeInfo, (long)System.currentTimeMillis());
    }

    @Override
    boolean executeCheckCanSkip(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to create PIPE [{}]", (Object)this.pipeInfo.getPipeName());
        env.getConfigManager().getSyncManager().checkAddPipe(this.pipeInfo);
        return false;
    }

    @Override
    void executePreOperatePipeOnConfigNode(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to pre-create PIPE [{}] on Config Nodes", (Object)this.pipeInfo.getPipeName());
        TSStatus status = env.getConfigManager().getSyncManager().preCreatePipe(this.pipeInfo);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.getMessage());
        }
    }

    @Override
    void executeOperatePipeOnDataNode(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to broadcast create PIPE [{}] on Data Nodes", (Object)this.pipeInfo.getPipeName());
        TSStatus status = RpcUtils.squashResponseStatusList(env.getConfigManager().getSyncManager().preCreatePipeOnDataNodes(this.pipeInfo));
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Fail to create PIPE [%s] on Data Nodes because %s", this.pipeInfo.getPipeName(), status.getMessage()));
        }
    }

    @Override
    void executeOperatePipeOnConfigNode(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("Start to create PIPE [{}] on Config Nodes", (Object)this.pipeInfo.getPipeName());
        TSStatus status = env.getConfigManager().getSyncManager().setPipeStatus(this.pipeInfo.getPipeName(), PipeStatus.STOP);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(status.getMessage());
        }
    }

    @Override
    SyncOperation getOperation() {
        return SyncOperation.CREATE_PIPE;
    }

    @Override
    protected boolean isRollbackSupported(OperatePipeState state) {
        switch (state) {
            case OPERATE_CHECK: 
            case OPERATE_PIPE_DATANODE: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, OperatePipeState state) throws IOException, InterruptedException, ProcedureException {
        LOGGER.error("Roll back CreatePipeProcedure at STATE [{}]", (Object)state);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeInt(ProcedureFactory.ProcedureType.CREATE_PIPE_PROCEDURE.ordinal());
        super.serialize(stream);
        this.pipeInfo.serialize((OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.pipeInfo = PipeInfo.deserializePipeInfo((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePipeProcedure that = (CreatePipeProcedure)o;
        return Objects.equals(this.pipeInfo, that.pipeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.pipeInfo);
    }
}

