/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.RegionMigrateProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.RemoveDataNodeState;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDataNodeProcedure
extends AbstractNodeProcedure<RemoveDataNodeState> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveDataNodeProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private TDataNodeLocation disableDataNodeLocation;
    private List<TConsensusGroupId> execDataNodeRegionIds = new ArrayList<TConsensusGroupId>();

    public RemoveDataNodeProcedure() {
    }

    public RemoveDataNodeProcedure(TDataNodeLocation disableDataNodeLocation) {
        this.disableDataNodeLocation = disableDataNodeLocation;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, RemoveDataNodeState state) {
        block10: {
            if (this.disableDataNodeLocation == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case REMOVE_DATA_NODE_PREPARE: {
                        env.markDataNodeAsRemovingAndBroadCast(this.disableDataNodeLocation);
                        this.execDataNodeRegionIds = env.getDataNodeRemoveHandler().getDataNodeRegionIds(this.disableDataNodeLocation);
                        LOG.info("{}, DataNode regions to be removed is {}", (Object)"[REMOVE_DATANODE_PROCESS]", this.execDataNodeRegionIds);
                        this.setNextState(RemoveDataNodeState.BROADCAST_DISABLE_DATA_NODE);
                        break;
                    }
                    case BROADCAST_DISABLE_DATA_NODE: {
                        env.getDataNodeRemoveHandler().broadcastDisableDataNode(this.disableDataNodeLocation);
                        this.setNextState(RemoveDataNodeState.SUBMIT_REGION_MIGRATE);
                        break;
                    }
                    case SUBMIT_REGION_MIGRATE: {
                        this.submitChildRegionMigrate(env);
                        this.setNextState(RemoveDataNodeState.STOP_DATA_NODE);
                        break;
                    }
                    case STOP_DATA_NODE: {
                        env.getDataNodeRemoveHandler().removeDataNodePersistence(this.disableDataNodeLocation);
                        env.getDataNodeRemoveHandler().stopDataNode(this.disableDataNodeLocation);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    this.setFailure(new ProcedureException("Remove Data Node failed " + (Object)((Object)state)));
                }
                LOG.error("Retrievable error trying to remove data node {}, state {}", new Object[]{this.disableDataNodeLocation, state, e});
                if (this.getCycles() <= 5) break block10;
                this.setFailure(new ProcedureException("State stuck at " + (Object)((Object)state)));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, RemoveDataNodeState state) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected boolean isRollbackSupported(RemoveDataNodeState state) {
        return false;
    }

    @Override
    protected boolean holdLock(ConfigNodeProcedureEnv env) {
        return true;
    }

    @Override
    protected RemoveDataNodeState getState(int stateId) {
        return RemoveDataNodeState.values()[stateId];
    }

    @Override
    protected int getStateId(RemoveDataNodeState removeDataNodeState) {
        return removeDataNodeState.ordinal();
    }

    @Override
    protected RemoveDataNodeState getInitialState() {
        return RemoveDataNodeState.REMOVE_DATA_NODE_PREPARE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeInt(ProcedureFactory.ProcedureType.REMOVE_DATA_NODE_PROCEDURE.ordinal());
        super.serialize(stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.disableDataNodeLocation, (DataOutputStream)stream);
        stream.writeInt(this.execDataNodeRegionIds.size());
        this.execDataNodeRegionIds.forEach(tid -> ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)tid, (DataOutputStream)stream));
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.disableDataNodeLocation = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
            int regionSize = byteBuffer.getInt();
            this.execDataNodeRegionIds = new ArrayList<TConsensusGroupId>(regionSize);
            for (int i = 0; i < regionSize; ++i) {
                this.execDataNodeRegionIds.add(ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)byteBuffer));
            }
        }
        catch (ThriftSerDeException e) {
            LOG.error("Error in deserialize RemoveConfigNodeProcedure", (Throwable)e);
        }
    }

    public boolean equals(Object that) {
        if (that instanceof RemoveDataNodeProcedure) {
            RemoveDataNodeProcedure thatProc = (RemoveDataNodeProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.disableDataNodeLocation.equals(this.disableDataNodeLocation);
        }
        return false;
    }

    private void submitChildRegionMigrate(ConfigNodeProcedureEnv env) {
        this.execDataNodeRegionIds.forEach(regionId -> {
            TDataNodeLocation destDataNode = env.getDataNodeRemoveHandler().findDestDataNode((TConsensusGroupId)regionId);
            if (destDataNode != null) {
                RegionMigrateProcedure regionMigrateProcedure = new RegionMigrateProcedure((TConsensusGroupId)regionId, this.disableDataNodeLocation, destDataNode);
                this.addChildProcedure(new RegionMigrateProcedure[]{regionMigrateProcedure});
                LOG.info("Submit child procedure, {}", (Object)regionMigrateProcedure);
            }
        });
    }
}

